function submitNote() {
    if (this.getParentView().validate()) {
        var formValues = $$("notes_form").getValues();
        webix.ajax().post("/wp-json/click-collect/v1/add-note/", {action: "note", formValues}, function (text, data, xhr) {
            if (data.json() === 'success') {
                webix.message({type:"message-style",text:"Comment added"});
                var note = {note_content: formValues.note};
                $$("notes_table").add(note);
            } else {
                webix.message({type:"message-style",text:"Sorry something went wrong, please try again"});
            }
        });
    }
}

(function () {

    jQuery.each(data, function (i, val) {

        $('#boxcontainer').append("<div id='box" + i + "'></div>");
        var order_status = [
            {id: 1, value: "New Order"},
            {id: 2, value: "Awaiting Processing"},
            {id: 3, value: "Started"},
            {id: 4, value: "Being Collated"},
            {id: 5, value: "Ready for collection"},
            {id: 6, value: "Collected"},
        ];

        console.log(val.length);
        var grid = {
            container: "box" + i,
            borderless: true,
            multi: true,
            rows: [
                {
                    header: '<div class="title">Order Collection Date: <span>' + i + '</span></div><div class="display"><strong>Display:</strong> <a>All: '+val.length+'</a>| <a>Needing made up: 0</a></div>',
                    footer: '<div class="title">Order Collection Date: <span>' + i + '</span></div><div class="display"><strong>Display:</strong> <a>All: '+val.length+'</a>| <a>Needing made up: 0</a></div>',

                    headerHeight:75,
                    collapsed: false,
                    body: {
                        view: "datatable",
                        editable: true,
                        footer:true,
                        borderless:true,
                        id: "box" + i,
                        position: "center",
                        rowHeight: 65,
                        columns: [
                            {
                                id: "id",
                                header: "Web order No.",
                                width: 150
                            },
                            {id: "client_name", header: "Client Name", width: 250},
                            {id: "contact_number", header: "Contact Number", width: 150},
                            {
                                id: "status",
                                fillspace: true,
                                header: "Status",
                                footer:"Print all orders",
                                width: 250,
                                editor: 'richselect',
                                options: order_status
                            },
                            {
                                id: "shop_order_number",
                                header: "Shop Order No.",
                                width: 150,
                                editor: 'text'
                            },
                            {
                                id: "action", header: "Action",
                                template: function (obj) {
                                    return "<div class='webix_el_button'><button class='add_notes'> Add Notes</button></div><div class='webix_el_button'><button class='view_order'> View</button></div>";
                                },
                                width: 250
                            }
                        ],
                        on: {
                            "onAfterEditStop": function (state, editor, ignoreUpdate) {
                                if (state.value !== state.old) {
                                    console.log(editor.row);
                                    //// UPDATE SHOP ORDER NUMBER /////
                                    if (editor.column === 'shop_order_number') {
                                        webix.ajax("/wp-json/click-collect/v1/set-shop-order-number/" + state.value + '/' + editor.row, function (text, data, xhr) {
                                            webix.message({type:"message-style",text:"Shop number saved"});
                                        });
                                    }
                                    //// UPDATE SHOP ORDER STATUS /////
                                    if (editor.column === 'status') {
                                        webix.ajax("/wp-json/click-collect/v1/update-order-status/" + state.value + '/' + editor.row, function (text, data, xhr) {
                                            webix.message({type:"message-style",text:"Status Updated"});
                                        });
                                    }
                                }
                            }
                        },
                        autoheight: true,
                        data: val,
                        onClick: {
                            "add_notes": function (e, id, trg) {
                                webix.message({type:"message-style",text:"Loading notes for order: " + id});
                                webix.ajax("/wp-json/click-collect/v1/get-notes/" + id, function (text, data, xhr) {
                                    windowInfo = data.json();
                                    if (windowInfo) {
                                        webix.ui({
                                            view: "window",
                                            id: "notes_window",
                                            head: {
                                                cols: [{template: '', borderless: true}, {}, {
                                                    view: "icon",
                                                    icon: "wxi-close-circle",
                                                    click: ("$$('notes_window').destructor();")
                                                }]
                                            },
                                            autoHeight: true,
                                            modal: true,
                                            position: "center",
                                            width: 1200,
                                            height: 800,
                                            borderless: true,
                                            body: {
                                                rows: [
                                                    {
                                                        id: "notes_table",
                                                        view: "datatable",
                                                        scroll: 'y',
                                                        css: "note-grid",
                                                        fixedRowHeight: false,
                                                        rowLineHeight: 25,
                                                        columns: [
                                                            {id: 'note_content', header: 'Note', fillspace: true},
                                                        ],
                                                        data: windowInfo,
                                                        on: {
                                                            "onresize": function () {
                                                                this.adjustRowHeight();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        view: "form",
                                                        id: "notes_form",
                                                        height: 200,
                                                        elements: [
                                                            {view: "textarea", label: "Add Note", name: "note",
                                                                labelWidth: 250,
                                                                labelAlign: 'right',
                                                            },
                                                            {
                                                                view: "button",
                                                                value: "Save",
                                                                label:"Save",
                                                                labelAlign:"center",
                                                                align:"left",
                                                                click: submitNote
                                                            },
                                                        ]
                                                    }
                                                ]
                                            }
                                        });
                                        $$("notes_window").show();
                                        $$("notes_form").setValues(
                                            {order_id: id}
                                        );
                                    }
                                });
                            },
                            "view_order": function (e, id, trg) {
                                var item = this.getItem(id);
                                console.log(item);
                                webix.message({type:"message-style",text:"Loading order: " + id});
                                webix.ajax("/wp-json/click-collect/v1/get-orders/" + id, function (text, data, xhr) {
                                    windowInfo = data.json();
                                    console.log(val);
                                    if (windowInfo) {
                                        webix.ui({
                                            view: "window",
                                            id: "order_window",
                                            head: {
                                                cols: [{template: ''}, {}, {
                                                    view: "icon",
                                                    icon: "wxi-close-circle",
                                                    click: ("$$('order_window').destructor();")
                                                }]
                                            },
                                            width: 1200,
                                            position: "center",
                                            autohight: true,
                                            move: true,
                                            body: {
                                                rows: [
                                                    {
                                                        height: 250,
                                                        cols: [
                                                            {
                                                                width: 800,
                                                                rows: [
                                                                    {
                                                                        template: '<strong>Date for Collection: </strong>' + windowInfo.pickup_date,
                                                                        borderless: true,
                                                                        autoheight: true
                                                                    },
                                                                    {
                                                                        template: '<strong>Client Name: </strong>' + item.client_name,
                                                                        borderless: true,
                                                                        autoheight: true
                                                                    },
                                                                    {
                                                                        template: '<strong>Contact Number: </strong>' + item.contact_number,
                                                                        borderless: true,
                                                                        autoheight: true
                                                                    },
                                                                    {
                                                                        template: '<strong>Web order no. </strong>' + item.id,
                                                                        borderless: true,
                                                                        autoheight: true
                                                                    },
                                                                    {},
                                                                    {},
                                                                    {
                                                                        cols: [
                                                                            {
                                                                                template: "<strong>Estimated Price: </strong>£" + windowInfo.price,
                                                                                borderless: true,
                                                                                autoheight: true
                                                                            },
                                                                            {
                                                                                view: "text",
                                                                                id: 'final_price',
                                                                                label: "<strong>Actual Price: £</strong>",
                                                                                placeholder: "Input Final Price",
                                                                                borderless: true,
                                                                                labelWidth: 250,
                                                                                labelAlign: 'right',
                                                                                value: item.final_price
                                                                            },
                                                                        ]
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                rows: [
                                                                    {
                                                                        view: "text",
                                                                        id: "shop_number",
                                                                        value: item.shop_order_number,
                                                                        label: 'Shop Order No.',
                                                                        labelAlign: "right",
                                                                        labelWidth: 250
                                                                    },
                                                                    {
                                                                        view: "select",
                                                                        id: "status_select",
                                                                        label: "Status",
                                                                        options: order_status,
                                                                        value: item.status,
                                                                        labelAlign: "right",
                                                                        labelWidth: 250
                                                                    },
                                                                    {},
                                                                    {},
                                                                    {},
                                                                    {},
                                                                    {
                                                                        borderless: true,
                                                                        autoheight: true,
                                                                        template: function (obj) {
                                                                            return "<div class='webix_el_button'><button class='add_notes'> Add Note</button></div><div class='webix_el_button'><button class='print_order'> Print Order</button></div>";
                                                                        },
                                                                        onClick: {
                                                                            "print_order": function (e, id, trg) {

                                                                                webix.print($$("order_window"), {
                                                                                    mode: "portrait",
                                                                                    fit: "page"
                                                                                });

                                                                            },
                                                                            "add_notes": function (e, id, trg) {
                                                                                webix.message({type:"message-style",text:"Loading notes for order: " + item.id});
                                                                                webix.ajax("/wp-json/click-collect/v1/get-notes/" + item.id, function (text, data, xhr) {
                                                                                    windowInfo = data.json();
                                                                                    if (windowInfo) {
                                                                                        webix.ui({
                                                                                            view: "window",
                                                                                            id: "notes_window",
                                                                                            head: {
                                                                                                cols: [{template: '', borderless: true}, {}, {
                                                                                                    view: "icon",
                                                                                                    icon: "wxi-close-circle",
                                                                                                    click: ("$$('notes_window').destructor();")
                                                                                                }]
                                                                                            },
                                                                                            autoHeight: true,
                                                                                            modal: true,
                                                                                            position: "center",
                                                                                            width: 1200,
                                                                                            height: 800,
                                                                                            borderless: true,
                                                                                            body: {
                                                                                                rows: [
                                                                                                    {
                                                                                                        id: "notes_table",
                                                                                                        view: "datatable",
                                                                                                        scroll: 'y',
                                                                                                        css: "note-grid",
                                                                                                        fixedRowHeight: false,
                                                                                                        rowLineHeight: 25,
                                                                                                        columns: [
                                                                                                            {id: 'note_content', header: 'Note', fillspace: true},
                                                                                                        ],
                                                                                                        data: windowInfo,
                                                                                                        on: {
                                                                                                            "onresize": function () {
                                                                                                                this.adjustRowHeight();
                                                                                                            }
                                                                                                        }
                                                                                                    },
                                                                                                    {
                                                                                                        view: "form",
                                                                                                        id: "notes_form",
                                                                                                        height: 200,
                                                                                                        elements: [
                                                                                                            {view: "textarea", label: "Add Note", name: "note",
                                                                                                                labelWidth: 250,
                                                                                                                labelAlign: 'right',
                                                                                                            },
                                                                                                            {
                                                                                                                view: "button",
                                                                                                                value: "Save",
                                                                                                                label:"Save",
                                                                                                                labelAlign:"center",
                                                                                                                align:"left",
                                                                                                                click: submitNote
                                                                                                            },
                                                                                                        ]
                                                                                                    }
                                                                                                ]
                                                                                            }
                                                                                        });
                                                                                        $$("notes_window").show();
                                                                                        $$("notes_form").setValues(
                                                                                            {order_id: item.id}
                                                                                        );
                                                                                    }
                                                                                });

                                                                            }

                                                                        }

                                                                    },


                                                                ]
                                                            },

                                                        ]
                                                    },
                                                    {height: 45, borderless: true},
                                                    {
                                                        template: '<h2>Items in order:</h2>',
                                                        autoheight: true,
                                                        borderless: true
                                                    },
                                                    {
                                                        view: "datatable",
                                                        autoheight: true,
                                                        rowHeight: 65,
                                                        columns: [
                                                            {
                                                                id: 'product_title',
                                                                header: 'Product Title',
                                                                fillspace: true
                                                            },
                                                            {id: 'weight', header: 'Weight (g)', fillspace: true},
                                                            {id: 'people', header: 'No. of People', fillspace: true},
                                                            {id: 'size', header: 'by Pack Size', fillspace: true},
                                                            {id: 'qty', header: 'Quantity', fillspace: true}
                                                        ],
                                                        data: windowInfo.orders
                                                    }
                                                ]
                                            },

                                        });
                                        $$("order_window").show();
                                        $$("shop_number").attachEvent("onBlur", function () {
                                            console.log($$('shop_number').getValue());
                                            webix.ajax("/wp-json/click-collect/v1/set-shop-order-number/" + $$('shop_number').getValue() + '/' + id, function (text, data, xhr) {
                                                var record = $$("box" + i);
                                                var item = record.getItem(id);
                                                item['shop_order_number'] = $$('shop_number').getValue();
                                                record.updateItem(id, item);
                                                webix.message({type:"message-style",text:"Shop number saved"});

                                            });
                                        });
                                        $$("final_price").attachEvent("onBlur", function () {
                                            console.log($$('final_price').getValue());
                                            webix.ajax("/wp-json/click-collect/v1/set-final-price/" + $$('final_price').getValue() + '/' + id, function (text, data, xhr) {
                                                webix.message({type:"message-style",text:"Final Price saved"});

                                            });
                                        });

                                        $$("status_select").attachEvent("onChange", function () {
                                            console.log($$('status_select').getValue());
                                            webix.ajax("/wp-json/click-collect/v1/update-order-status/" +$$('status_select').getValue() + '/' +  id, function (text, data, xhr) {
                                                webix.message({type:"message-style",text:"Status Updated"});
                                            });
                                        });
                                    }
                                });

                            }
                        },

                    }
                },
                {height:35}
            ]
        };
        webix.ready(function () {
            webix.ui(grid);
        });

    });

})();