const favourite = () => {
    $('.type-product .favourite-set').each((_index, val) => {
        $(val).unbind('click')
            .bind('click', e => {
                e.preventDefault();
                const productId = $(val).data('id');
                $.ajax({
                    url: ajaxurl, // eslint-disable-line
                    data: {
                        action: 'setFavouriteProduct',
                        product: productId,
                    },
                    type: 'POST'
                }).done(data => {
                    console.log(data);
                    if (data === 'OK') {
                        $(val).toggleClass('active');
                        if ($(val).hasClass('active')) {
                            $(val).find('.bookmark-icon')
                                .first()
                                .attr('data-prefix', 'fas');
                        } else {
                            $(val).find('.bookmark-icon')
                                .first()
                                .attr('data-prefix', 'far');
                        }
                    }
                })
                    .fail(data => {
                        console.log(data);
                    });
            });
    });

    $('.favourite-remove__product').each((_index, val) => {
        $(val).click(e => {
            e.preventDefault();
            const productId = $(val).data('id');
            $.ajax({
                url: ajaxurl, // eslint-disable-line
                data: {
                    action: 'setFavouriteProduct',
                    product: productId,
                },
                type: 'POST',
            })
                .done(data => {
                    if (data === 'OK') {
                        const area = $(val).closest('.favourite-row');
                        $(val).closest('.favourite-col')
                            .remove();
                        if ($.trim($(area).html()) === '') {
                            $(area).html('<div class="no-rows">You do not have any favourite products...</div>');
                        }
                    }
                })
                .fail(data => {
                    console.log(data);
                });
        });
    });
};

export default favourite;
