<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
    return;
}
$prodID = $product->get_id();
if( has_term( array( 'sale' ), 'product_cat', $product->get_id() ) || has_term( array( 'Sale' ), 'product_cat', $product->get_id() )) {
    $inSale=true;
    $classes='cat-sale';
}else{
    $classes='';
}
?>
<li <?php wc_product_class( $classes, $product ); ?>>

    <?php

    $favouriteClass = is_account_page() ? 'favourite-remove__product' : 'favourite-set';

    if(is_user_logged_in()) {
        $ID = get_current_user_id();
        $favourites = get_field('favourite_products', 'user_' . $ID);
        $active = ($favourites && in_array(get_the_ID(), $favourites));
        ?>
        <a href="#" class="<?= $favouriteClass; ?> favourite-button" data-id="<?= $prodID; ?>">
            <span class="fa-stack fa-2x">
              <i class="fas fa-circle fa-stack-2x circle-icon"></i>
              <?php if (!is_account_page()) { ?>
                  <i class="<?= $active ? 'fas' : 'far' ?> fa-bookmark fa-stack-1x fa-inverse bookmark-icon"></i>
              <?php } else { ?>
                  <i class="far fa-times fa-stack-1x fa-inverse bookmark-icon"></i>
              <?php } ?>
            </span>
        </a>
    <?php } ?>


    <?php
    /**
     * Hook: woocommerce_before_shop_loop_item.
     *
     * @hooked woocommerce_template_loop_product_link_open - 10
     */
    //do_action( 'woocommerce_before_shop_loop_item' );

    /**
     * Hook: woocommerce_before_shop_loop_item_title.
     *
     * @hooked woocommerce_show_product_loop_sale_flash - 10
     * @hooked woocommerce_template_loop_product_thumbnail - 10
     */
    woocommerce_show_product_loop_sale_flash();
    ?>
    <div class="image-wrap">
        <?php
        woocommerce_template_loop_product_link_open();
        woocommerce_template_loop_product_thumbnail();
        woocommerce_template_loop_product_link_close();
        woocommerce_template_loop_add_to_cart();
        //echo do_shortcode("[add_to_cart]");
        ?>
        <a href="#product-<?= $prodID; ?>" data-quantity="1" class="button product_type_simple add_to_cart_button quick_buy_button" rel="nofollow">Quick Buy</a>
        <?
        ?>
    </div>
    <?php
    //do_action( 'woocommerce_before_shop_loop_item_title' );

    /**
     * Hook: woocommerce_shop_loop_item_title.
     *
     * @hooked woocommerce_template_loop_product_title - 10
     */
    woocommerce_template_loop_product_link_open();
    do_action( 'woocommerce_shop_loop_item_title' );

    /**
     * Hook: woocommerce_after_shop_loop_item_title.
     *
     * @hooked woocommerce_template_loop_rating - 5
     * @hooked woocommerce_template_loop_price - 10
     */
    do_action( 'woocommerce_after_shop_loop_item_title' );
    if( $inSale ) {
        echo '<span class="sale-tag">Sale</span>';
    }
    woocommerce_template_loop_product_link_close();
    /**
     * Hook: woocommerce_after_shop_loop_item.
     *
     * @hooked woocommerce_template_loop_product_link_close - 5
     * @hooked woocommerce_template_loop_add_to_cart - 10
     */
    //do_action( 'woocommerce_after_shop_loop_item' );
    ?>
    <div id="product-<?= $prodID; ?>" class="product-modal-content">
        <span class="close-modal">X</span>
        <div class="modal-content container-fluid">
            <div class="row">
                <div class="modal-content-col col-md-6 order-2 order-md-1">
                    <?=
                    get_the_post_thumbnail($prodID, 'large', ['class' => 'alignleft']);
                    ?>
                </div>
                <div class="modal-content-col col-md-6 order-1 order-md-2 text-left">
                    <?=woocommerce_template_single_rating();?>
                    <h2><?= get_the_title($prodID); ?></h2>

                    <div class="price-info-holder">
                        <?php
                        woocommerce_template_single_price();
                        if( $inSale ) {
                            echo '<span class="sale-tag">Sale</span>';
                        }
                        ?>
                    </div>

                    <div class="product-indent">
                        <?php
                        woocommerce_template_single_excerpt();
                        if ( ! $product->managing_stock() && ! $product->is_in_stock() ){
                            echo 'Out of Stock';
                        }else{
                            woocommerce_template_single_add_to_cart();
                            woocommerce_template_loop_add_to_cart();
                            echo do_shortcode("[add_to_cart]");
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</li>
