<?php
$showSiteBanner = get_field('show_site_banner_notice','option');
$siteBannerText = get_field('site_banner_text','option');
$siteBannerLink = get_field('site_banner_link','option');
$giftCardHeaderToggle = get_field('gift_card_header_toggle', 'option');


if($showSiteBanner){
    ?>
    <div class="site-banner-notice">
        <p class="content-container"><?=$siteBannerText;?> 
        <?php if($siteBannerLink) { ?>
            <a href="<?=$siteBannerLink['url'];?>" target="<?=$siteBannerLink['target'];?>"><?=$siteBannerLink['title'];?></a>
        <?php
            }
        ?>
        </p>
        <span class="site-banner-notice__close"><i class="far fa-times"></i></span>
    </div>
    <?php
}
?>


<div class="site-header container-fluid">
    <?php $logo = get_field('company_logo', 'option'); ?>
    <nav class="header-nav">
        <div class="main-nav-wrapper">
            <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                <img src="<?= $logo['url']; ?>" alt="<?php bloginfo('name'); ?>"/>
            </a>
            <div class="main-navigation" id="navbarSupportedContent">
                <?php
                $brandArgs = [
                    'parent' => 0,
                    'hide_empty' => 0,
                ];
                $brands = get_terms('brand', $brandArgs);
                $departmentPageArgs = [
                    'meta_key' => '_wp_page_template',
                    'meta_value' => 'template-department.php',
                    'hierarchical' => 0,
                    'post_status' => 'publish'
                ];
                $departmentPages = get_pages($departmentPageArgs);
                $departmentPageIDs = [];
                foreach ($departmentPages as $departmentPage) {
                    array_push($departmentPageIDs, get_field('brand', $departmentPage->post_id)->term_id);
                }
                if ($brands) {
                    ?>
                    <ul class="nav--departments" id="nav--departments">
                        <?php
                        $i = 0;
                        foreach ($brands

                        as $brand) {
                        $catParent = get_term_by('slug', $brand->slug, 'product_cat');
                        $i++;
                        $image = get_field('brand_logo', 'brand_' . $brand->term_id);
                        $featuredBrands = get_field('featured_brands', 'brand_' . $brand->term_id);
                        $maintenance = get_field('maintenance', 'brand_' . $brand->term_id);
                        $link_overlay = get_field('link_overlay', 'brand_' . $brand->term_id);
                        if ($maintenance) {
                            $brandUrl = '';
                            $linkClasses = 'preventDefault maintenance--on';
                        } else {
                            $departmentIndex = array_search($brand->term_id, $departmentPageIDs);
                            $linkClasses = 'preventDefault';
                            if ($departmentIndex !== FALSE) {
                                $brandUrl = get_permalink($departmentPages[$departmentIndex]->post_id);
                            } else {
                                $brandUrl = get_category_link($brand->term_id);
                            }
                        }
                        ?>
                        <li class="nav--department">
                                <span class="link-wrapper">
                                <a class="<?= $linkClasses; ?>" href="<?= $brandUrl; ?>">
                                <?php if ($image) { ?>
                                    <img src='<?= $image['url']; ?>'
                                         alt=''/><?php } ?><?= $brand->name; ?><?php if ($maintenance) {
                                        ?>
                                        <span class="cat-overlay"><?= $link_overlay; ?></span>
                                        <?php
                                    }
                                    ?>
                                </a>
                                <?php if (!$maintenance) { ?>
                                    <span class="preventDefault tool mobile-nav-toggler__dept show-on-mobile"><i
                                                class="far fa-chevron-down"></i></span>
                                    <?php
                                }
                                ?>
                                </span>
                            <?php
                            // Subnavs
                            $brandsID = NULL;
                            $brandUL = NULL;
                            if (!$maintenance) {
                                $subBrandArgs = [
                                    'hierarchical' => 1,
                                    'show_option_none' => '',
                                    'hide_empty' => 0,
                                    'parent' => $brand->term_id,
                                    'taxonomy' => 'brand',
                                    'brand'
                                ];
                                $subBrands = get_categories(
                                    $subBrandArgs
                                );
                                $subBrandArgs = [
                                    'meta_key' => '_wp_page_template',
                                    'meta_value' => 'template-brand.php',
                                    'hierarchical' => 0,
                                    'post_status' => 'publish'
                                ];
                                $subBrandPages = get_pages($subBrandArgs);
                                $brandPageTermIDs = [];
                                foreach ($subBrandPages as $subBrandPage) {
                                    array_push($brandPageTermIDs, get_field('brand', $subBrandPage->post_id)->term_id);
                                }
                                ?>
                                <ul class="department-wrapper">
                                    <li><span class="navitem">Brands</span><span class="nav-toggler"><i
                                                    class="far fa-chevron-down"></i></span>
                                        <ul class="department-sub">

                                            <li>
                                                <div class="container-fluid container--department">
                                                    <?php
                                                    //Featured Brands
                                                    if ($featuredBrands) {
                                                        ?>
                                                        <div>
                                                            <strong>
                                                                <a class="sub-heading">Featured Products</a>
                                                            </strong>
                                                            <ul class="department-sub__featured-brands">
                                                                <?php
                                                                if ($subBrands) {
                                                                    foreach ($featuredBrands as $featuredBrand) {
                                                                        $subBrand = get_term($featuredBrand);
                                                                        $brandIndex = array_search($subBrand->term_id, $brandPageTermIDs);
                                                                        if ($brandIndex !== FALSE) {
                                                                            $subBrandPages[$brandIndex];
                                                                            ?>
                                                                            <li>
                                                                                <a href="<?= get_permalink($subBrandPages[$brandIndex]->post_id); ?>"><?= get_field('brand', $subBrandPages[$brandIndex]->post_id)->name; ?></a>
                                                                            </li>
                                                                            <?php
                                                                        } else {
                                                                            ?>
                                                                            <li>
                                                                                <a href="<?= get_category_link($subBrand->term_id); ?>"><?= $subBrand->name; ?></a>
                                                                            </li>
                                                                            <?php
                                                                        }
                                                                    }
                                                                }
                                                                ?>
                                                            </ul>
                                                        </div>
                                                        <?php
                                                    } //
                                                    ?>
                                                    <?php
                                                    // Get Brands
                                                    if ($subBrands) {
                                                        ?>
                                                        <div>
                                                            <strong><a class="sub-heading">A-Z Brands</a></strong>
                                                            <ul class="department-sub__brands">
                                                                <?php
                                                                foreach ($subBrands as $subBrand) {
                                                                    $brandIndex = array_search($subBrand->term_id, $brandPageTermIDs);
                                                                    if ($brandIndex !== FALSE) {
                                                                        ?>
                                                                        <li>
                                                                            <a href="<?= get_permalink($subBrandPages[$brandIndex]->post_id); ?>"><?= get_field('brand', $subBrandPages[$brandIndex]->post_id)->name; ?></a>
                                                                        </li>
                                                                        <?php
                                                                    } else {
                                                                        ?>
                                                                        <li>
                                                                            <a href="<?= get_category_link($subBrand->term_id); ?>"><?= $subBrand->name; ?></a>
                                                                        </li>
                                                                        <?php
                                                                    }
                                                                }
                                                                ?>
                                                            </ul>
                                                        </div>
                                                        <?php
                                                    } // end if subBrands
                                                    ?>
                                                </div>
                                            </li>
                                        </ul>
                                        <!-- end Department Sub -->
                                        <?php
                                        //Fragrance of the month
                                        $args = [
                                            'meta_key' => '_wp_page_template',
                                            'meta_value' => 'template-scent-of-the-month.php',
                                            'hierarchical' => 0,
                                            'post_status' => 'publish'
                                        ];
                                        $scentPages = get_pages($args);
                                        if ($scentPages && strpos($brand->slug, 'candle') !== FALSE){
                                        ?>
                                    <li><span class="navitem">Scents of the Month</span><span class="nav-toggler"><i
                                                    class="far fa-chevron-down"></i></span>
                                        <ul class="department-sub">
                                            <li>
                                                <div class="top-nav--<?= $i; ?>'">
                                                    <div class="container-fluid container--department">
                                                        <div>
                                                            <ul class="department-sub__featured-brands department-sub__scents">
                                                                <?php
                                                                foreach ($scentPages as $scentPage) {
                                                                    $scentPageTitle = str_ireplace(["Scent of the month - ", "Scents Of The Month - "], "", $scentPage->post_title);

                                                                    ?>
                                                                    <li>
                                                                        <a href="<?= get_permalink($scentPage->post_id); ?>"><?= $scentPageTitle; ?></a>
                                                                    </li>
                                                                    <?php
                                                                }
                                                                ?>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </li>

                                    <?php
                                    }
                                    ?>

                                    <?php

                                    $subBrandArgs = [
                                        'hierarchical' => 1,
                                        'show_option_none' => '',
                                        'hide_empty' => 1,
                                        'parent' => $brand->term_id,
                                        'taxonomy' => 'brand',
                                        'brand'
                                    ];
                                    $subBrands = get_categories(
                                        $subBrandArgs
                                    );
                                    $catArgs = [
                                        'hierarchical' => 1,
                                        'show_option_none' => '',
                                        'hide_empty' => 1,
                                        'taxonomy' => 'product_cat'
                                    ];
                                    $cats = get_categories(
                                        $catArgs
                                    );
                                    ?>

                                    <li class="department-nav--shop"><a href="<?= $brandUrl; ?>">Shop</a><span
                                                class="nav-toggler"><i class="far fa-chevron-down"></i></span>
                                        <ul class="department-sub">
                                            <li>
                                                <div class="container-fluid container--department">
                                                    <div>
                                                        <ul>
                                                            <li>
                                                                <div>
                                                                    <strong><a class="sub-heading">A-Z
                                                                            Brands</a></strong>
                                                                    <ul class="department-sub__shop-brands">
                                                                        <?php
                                                                        foreach ($subBrands as $subBrand) {
                                                                            ?>
                                                                            <li>
                                                                                <a href="/shop/?swoof=1&brand=<?= $subBrand->slug; ?>"><?= $subBrand->name; ?></a>
                                                                            </li>
                                                                            <?php
                                                                        }
                                                                        ?>
                                                                    </ul>
                                                                </div>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                    <div>
                                                        <strong><a class="sub-heading">Product Categories</a></strong>
                                                        <ul class="department-sub__shop-cats">
                                                            <?php
                                                            foreach ($cats as $cat) {
                                                                // Check top cat parent matches current department
                                                                $termParent = get_term($cat, 'product_cat');
                                                                // Climb up the hierarchy until we reach a term with parent = '0'
                                                                $termParentSlug = $termParent->slug;
                                                                while ($termParent->parent != '0') {
                                                                    $term_id = $termParent->parent;
                                                                    $termParent = get_term($term_id, 'product_cat');
                                                                }
                                                                $displayCat = $termParent == $catParent;
                                                                if (strpos($catParent, $cat->slug) !== FALSE) {
                                                                    $displayCat = TRUE;
                                                                }
                                                                if (strtolower($cat->name) !== 'uncategorized' && strtolower($cat->name) !== 'gift card' && strtolower($cat->name) !== 'gift wrapping' && $displayCat == TRUE && $termParentSlug !== $brand->slug) {
                                                                    ?>
                                                                    <li>
                                                                        <a href="/shop/?swoof=1&product_cat=<?= $cat->slug ?>"><?= $cat->name; ?></a>
                                                                    </li>
                                                                    <?php
                                                                }
                                                            }
                                                            ?>
                                                        </ul>
                                                    </div>

                                                </div>
                                            </li>
                                        </ul>
                                    </li>
                                    <?php
                                    $additionalNavItems = get_field('additional_main_menu_items', 'brand_' . $brand->term_id);
                                    foreach ($additionalNavItems as $navItem) {
                                        ?>
                                        <li class="department-nav department-nav--additional-nav-items">
                                            <?php
                                            if ($navItem['menu_item'] !== '') {
                                                $link = $navItem['menu_item']['url'];
                                                $linkText = $navItem['menu_item']['title'];
                                                $linkTgt = $navItem['menu_item']['target']; ?>
                                                <a href="<?= $link; ?>" target="<?= $linkTgt; ?>"><?= $linkText; ?></a>
                                            <?php } else if ($navItem['menu_item_category']) {
                                                $link = get_term($navItem['menu_item_category']->term_id);
                                                $linkText = $navItem['menu_item_category']->name;
                                                $linkTgt = '_self'; ?>
                                                <a href="/shop/?swoof=1&product_cat=<?= $link->slug ?>"><?= $link->name; ?></a>
                                            <?php }

                                            ?>
                                        </li>
                                        <?php
                                    }
                                    ?>

                                    </li>
                                </ul>
                                <?php
                            }
                            }
                            ?>
                    </ul>
                    <?php
                }
                ?>


                <div class="tools tools--mobile">
                    <div class="tools tool--icons">
                        <?php if ($giftCardHeaderToggle) { ?>
                            <a class="tool" href="/product/gift-card/">
                                <i class="far fa-gift"></i>
                            </a>
                        <?php } ?>
                        <?php if (is_user_logged_in()) { ?>
                            <a class="tool"
                               href="<?php echo get_permalink(get_option('woocommerce_myaccount_page_id')); ?>"
                               title="<?php _e('My Account', 'woothemes'); ?>"><i class="far fa-user"></i></a>
                        <?php } else { ?>
                            <a class="tool"
                               href="<?php echo get_permalink(get_option('woocommerce_myaccount_page_id')); ?>"
                               title="<?php _e('Login / Register', 'woothemes'); ?>"><i class="far fa-user"></i></a>
                        <?php } ?>
                        <?php if (is_user_logged_in()) { ?>
                            <a href="/my-account/favourites/" class="tool">
                                <i class="far fa-bookmark"></i>
                            </a>
                        <?php } ?>
                    </div>
                    <?php
                    get_search_form();
                    ?>
                </div>
            </div>
        </div>
        <div class="tools tools--lg">
            <div class="tools tool--icons">
                <?php if ($giftCardHeaderToggle) { ?>
                    <a class="tool" href="/product/gift-card/">
                        <i class="far fa-gift"></i>
                    </a>
                <?php } ?>
                <?php if (is_user_logged_in()) { ?>
                    <a class="tool" href="<?php echo get_permalink(get_option('woocommerce_myaccount_page_id')); ?>"
                       title="<?php _e('My Account', 'woothemes'); ?>"><i class="far fa-user"></i></a>
                <?php } else { ?>
                    <a class="tool" href="<?php echo get_permalink(get_option('woocommerce_myaccount_page_id')); ?>"
                       title="<?php _e('Login / Register', 'woothemes'); ?>"><i class="far fa-user"></i></a>
                <?php } ?>
                <?php if (is_user_logged_in()) { ?>
                    <a href="/my-account/favourites/" class="tool">
                        <i class="far fa-bookmark"></i>
                    </a>
                <?php } ?>
                <a href="#" class="tool mini-cart--toggle show-on-mobile">
                    <i class="far fa-shopping-bag" aria-hidden="true"></i>
                    <div class="basket-item-count">
                        <span class="cart-items-count count">
                        <?= WC()->cart->get_cart_contents_count(); ?>
                        </span>
                    </div>
                </a>
                <a class="tool mobile-nav-toggler show-on-mobile">
                    <i class="far fa-bars"></i>
                    <i class="far fa-times"></i>
                </a>
                <div class="mini-cart mini-cart--side">
                    <ul class="mini-cart-items">
                        <li>
                            <div class="widget_shopping_cart_content">
                                <?php woocommerce_mini_cart(); ?>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
            <?php
            get_search_form();
            ?>
        </div>
    </nav>
</div>
