    <?php
    $brand = get_field('brand');
    $popular = get_field('popular');
    if( $popular && $brand){ 
    $showMobIntro= false;
    if ($popular['popular_introduction_mobile']){
        $showMobIntro = true;
    }
    ?>
    <section class="popular-cats content-container">
        <div class="section__intro">
            <div class="row">
                <div class="col-12 text-center<?php if ($showMobIntro){ echo ' d-none d-sm-block';}?>">
                    <?=$popular['popular_introduction'];?>
                </div>
                <?php
                    if ($showMobIntro){
                ?>
                <div class="col-12 d-sm-none text-center">
                    <?=$popular['popular_introduction_mobile'];?>
                </div>
                <?php
                    }
                ?>
            </div>
        </div>
        <div class="row flex-row flex-wrap">
            <?php 
                //Look for product cats in popular cats repeater.
                $popular_cats = $popular['popular_cats'];
                if( $popular_cats ) {
                    foreach( $popular_cats as $popular_cat ) {
                        $collections = $popular_cat['show_collections'];
                        if($collections){
                            $term = $popular_cat['collection'];
                            $tax='brand_';
                            
                        }else{
                            $term = $popular_cat['category'];
                            $tax='product_cat_';
                        }
                        // Look for Category images with fallbacks.
                        // Get default Cat image
                        $thumbnail_id = get_term_meta( $term->term_id, 'thumbnail_id', true ); 
                        $imageUrl = wp_get_attachment_image_src( $thumbnail_id ,'large'); 
                        //Get image from Cat or Brand
                        if($collections){
                            $image = get_field('brand_featured_image',$tax.$term->term_id);
                            $size = 'large';
                            if($image){
                                $imageUrl=$image['sizes'][ $size ];
                            }
                        }else{
                            $catImgRows = get_field('category_image_by_brand',$tax.$term->term_id);
                            if( $catImgRows ) {
                                foreach( $catImgRows as $catImgRow ) {
                                    if( $catImgRow['brand']->name == $brand->name ){
                                        $image = $catImgRow['brand_category_image'];
                                        $size = 'large';
                                        $imageUrl = $image['sizes'][ $size ];
                                        break;
                                    }
                                }
                            }
                        }
                        
                        // Get image from page if set.
                        if ($popular_cat['image']){
                            $image = $popular_cat['image'];
                            $size = 'large';
                            $imageUrl=$image['sizes'][ $size ];
                        }
                        if($collections){
                            $link = esc_url( get_term_link( $term ) );
                        }else{
                            $link = '/product-category/'.$term->slug.'?swoof=1&brand='.$brand->slug.'&product_cat='.$term->slug;
                        }
                        $excerpt = mb_strimwidth(esc_html( $term->description ), 0, 50, '...');
                        $caption = get_field('caption',$tax.$term->term_id);
                        if($caption){
                            $excerpt = $caption;
                        }
                        ?>
                        <div class="col cat-col">
                            <div class="cat-panel">
                                <a href="<?=$link; ?>">
                                    <div class="img-wrapper">
                                        <img class="img-fluid" src="<?=$imageUrl;?>" alt="<?=$term->name;?>">
                                    </div>
                                    <h2><?php echo esc_html( $term->name ); ?></h2>
                                    <p><?=$excerpt?></p>
                                </a>
                            </div>
                        </div>
                        <?php
                    }
                }
            ?>
        </div>
        <div class="col text-center">
            <a class="btn btn-primary" href="/brand/<?=$brand->slug;?>">Explore all products</a>
        </div>
    </section>
    <?php } ?>
