<?php
namespace Blue2\Scruffy\Controllers;

class ShopController{

    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'woocommerceHookAdjustments']);
        add_action( 'woocommerce_product_options_pricing', [$this, 'wc_onbuy_cost_field'] );
        add_action( 'save_post', [$this,'wc_onbuy_cost_save_product'] );
    }

    private function registerFilters()
    {
        add_filter('woocommerce_pagination_args', 	[$this, 'alterWooPagination'] );
        add_filter('woocommerce_sale_flash', [$this, 'removeWooSaleBadge']);
        add_filter('woocommerce_account_menu_items', [$this, 'updateAccountMenu'], 999 );
    }

    public function woocommerceHookAdjustments()
    {
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
    }

    public function alterWooPagination( $args ) {

        $args['prev_text'] = 'Previous';
        $args['next_text'] = 'Next';

        return $args;
    }

    function removeWooSaleBadge()
    {
        return false;
    }

    public function updateAccountMenu($items) {
        unset($items['downloads']);
        return $items;
    }

    public function wc_onbuy_cost_field() {
        woocommerce_wp_text_input( array( 'id' => 'onbuy_price', 'class' => 'wc_input_price short', 'label' => __( 'OnBuy Price', 'woocommerce' ) . ' (' . get_woocommerce_currency_symbol() . ')' ) );
    }

    public function wc_onbuy_cost_save_product( $product_id ) {
        // stop the quick edit interferring as this will stop it saving properly, when a user uses quick edit feature
        if (wp_verify_nonce($_POST['_inline_edit'], 'inlineeditnonce'))
            return;

        // If this is a auto save do nothing, we only save when update button is clicked
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
            return;

        if ( isset( $_POST['onbuy_price'] ) ) 
        {
            if ( is_numeric( $_POST['onbuy_price'] ) ) {
                update_post_meta( $product_id, 'onbuy_price', $_POST['onbuy_price'] );
            }
        } else {
            delete_post_meta( $product_id, 'onbuy_price' );
        }
    }
}
