import Swiper, { Navigation, Pagination, Autoplay, EffectFade } from 'swiper';
Swiper.use([Navigation, Pagination, Autoplay, EffectFade]);
import 'swiper/swiper-bundle.css';

let brandsCarousel = 'undefined';
let brandsCarouselMobile = 'undefined';
const common = () => {
    console.log('This gets run on every page and is exported as the default funciton. This will require a function call to run');

    function createCookie(name, value, days) {
        console.log(name);
        let expires = '';
        if (days) {
            const date = new Date();
            date.setTime(date.getTime() + days * 24 * 60 * 60 * 1000);
            // expires = '; expires=' + date.toGMTString();
            expires = `; expires= ${date.toGMTString()}`;
        } else {
            expires = '';
        }
        // document.cookie = name + '=' + value + expires + '; path=/';
        document.cookie = `${name}=${value}${expires}; path=/`;
    }
    function readCookie(name) {
        const nameEQ = `${name}=`;
        const ca = document.cookie.split(';');
        for (let i = 0; i < ca.length; i++) {
            let c = ca[i];
            while (c.charAt(0) === ' ') {
                c = c.substring(1, c.length);
            }
            if (c.indexOf(nameEQ) === 0) {
                return c.substring(nameEQ.length, c.length);
            }
        }
        return null;
    }
    function eraseCookie(name) {
        createCookie(name, null, -1);
    }

    const mainNav = document.getElementById('nav--departments');
    const primaryDept = mainNav.firstElementChild;
    primaryDept.classList.add('active');

    const noClicks = document.querySelectorAll('.preventDefault');
    noClicks.forEach(function(noClick) {
        noClick.addEventListener('click', function(e) {
            e.preventDefault();
        });
    });
    const departmentNavs = document.querySelectorAll('.nav--department');
    departmentNavs.forEach(function(departmentNav) {
        departmentNav.addEventListener('click', function(e) {
            // e.stopPropagation();
            const deptLink = departmentNav.querySelectorAll('.maintenance--on');
            if (deptLink.length < 1) {
                if (this.classList.contains('active')) {
                    // alert(e.target.tagName);
                    const linkEl = this.querySelectorAll('.link-wrapper>a');
                    const url = linkEl[0].getAttribute('href');
                    if (url !== '' && e.target.tagName === 'A') {
                        window.location.href = url;
                    }
                }
                departmentNavs.forEach(function(departmentNav) {
                    departmentNav.classList.remove('active');
                });
                departmentNav.classList.add('active');
            }
        });
    });
    const bannerNotice = readCookie('casa-banner-notice');
    if (bannerNotice === 'dismissed') {
        $('.site-banner-notice').css('display','none')
            .removeClass('site-notice--on');
    } else {
        $('.site-banner-notice').css('display','block')
            .addClass('site-notice--on');
    }
    $('.site-banner-notice__close').on('click',function() {
        createCookie('casa-banner-notice', 'dismissed', 1);
        $('.site-banner-notice').slideUp()
            .removeClass('site-notice--on');
    });
    $('.main-navigation>.nav--departments>.nav--department').each(function() {
        const myWidth = $('.link-wrapper',this).width() + 20;
        $(this).css('max-width',myWidth);
    });
    $('.mini-cart--toggle').on('click',function() {
        $('.mini-cart').toggleClass('mini-cart--open');
        $('body').toggleClass('page-overlay--on');
    });
    $('.mini-cart').on('click','.mini-cart--close',function() {
        $('.mini-cart').removeClass('mini-cart--open');
        $('body').removeClass('page-overlay--on');
    });

    $('.nav-toggler').on('click',function() {
        const me = $(this).parent();
        $('.main-navigation .nav--active')
            .not(me)
            .removeClass('nav--active');
        me.toggleClass('nav--active');
    });

    $('.mobile-nav-toggler').on('click',function() {
        $('.main-navigation, .header-nav').toggleClass('mobile-nav--active');
        $('body').toggleClass('page-overlay--on--mobile');
    });

    $('.mobile-nav-toggler__dept').on('click',function() {
        const parentDept = $(this).parentsUntil('.nav--department')
            .parent();
        if (parentDept.hasClass('active')) {
            $('.main-navigation, .header-nav').toggleClass('mobile-nav--active');
            $('body').toggleClass('page-overlay--on--mobile');
        } else {
            $('.main-navigation, .header-nav').addClass('mobile-nav--active');
            $('body').addClass('page-overlay--on--mobile');
        }
    });

    $('.nav--department.active>a').on('click',function() {
        $('.mobile-nav-toggler').trigger('click');
    });

    // Populate international shipping enquiry form with cart items.
    if ($('#internationalShipping-products').length > 0) {
        let cartItems = '';
        $('.woocommerce-mini-cart-item').each(function() {
            const productUrl = $(this).find('.product-link')
                .attr('href');
            const productName = $(this).find('.product-name--minicart')
                .text()
                .trim();
            const qty = $(this).find('.quantity')
                .attr('data-qty');
            cartItems += (`${qty} x ${productName} \r\n${productUrl} \r\n \r\n`);
            $('#internationalShipping-products').val(cartItems);
        });
    }

    /*
    const infiniteScroll = {
        loading: {
            //img: "/img/loading-animation.gif",
            msgText: 'loadin',
        },
        nextSelector: '.page-numbers a.next',
        navSelector: '.page-numbers',
        itemSelector: '#main ul.products .product',
        contentSelector: '#main ul.products'
    };

    //Unbind load more on scroll
    $(window).unbind('.infscr');

    $('#load-more-button').click(function() {
        $(document).trigger('retrieve.infscr');
    });
    */

    const loadStatus = '<div class="page-load-status">  <p class="infinite-scroll-request"><span class="lds-dual-ring"></span></p>  <p class="infinite-scroll-last">No more products to display.</p>  <p class="infinite-scroll-error">No more products to display.</p></div>';
    $('.woocommerce-pagination').before(`${loadStatus}<span class="btn btn-primary load-more-button">Load More</span>`);
    $('.custom-pagination > .pagination').before(`${loadStatus}<span class="btn btn-primary load-more-button">Load More</span>`);
    $('.custom-pagination .nav-links, .woocommerce-pagination .page-numbers').addClass('page-numbers-container');
    $('#main ul.products').infiniteScroll({
        // options
        path: '.page-numbers a.next',
        append: '#main ul.products .product',
        history: false,
        status: '.page-load-status',
        button: '.load-more-button',
        // load pages on button click
        scrollThreshold: false,
        // disable loading on scroll
    });
    $('.custom-search-results.woocommerce ul.products').infiniteScroll({
        // options
        path: '.nav-links a.next',
        append: '.custom-search-results.woocommerce ul.products .product',
        history: false,
        status: '.page-load-status',
        button: '.load-more-button',
        // load pages on button click
        scrollThreshold: false,
        // disable loading on scroll
    });

    const swiperDelay = 4000;
    const initSwipers = function() {
        $('.swiper-container').each(function() {
            if ($('.swiper-slide', this).length === 1) {
                $('.swiper-wrapper',this).addClass('disabled');
                $('.swiper-pagination',this).addClass('disabled');
            }
        });
        const mySwiper = new Swiper('.swiper-container--paused', {
            // Optional parameters
            loop: true,
            // If we need pagination
            pagination: {
                el: '.swiper-pagination',
                type: 'bullets',
                clickable: true
            },
            watchOverflow: true
        });

        $('.swiper-container--autoplay').each(function() {
            if ($('.swiper-wrapper',this).hasClass('disabled') === false) {
                $(this).addClass('swiper-autoplay-init');
                const autoplaySwiper = new Swiper('.swiper-autoplay-init', {
                    // Optional parameters
                    loop: true,
                    speed: 500,
                    autoplay: {
                        delay: swiperDelay,
                    },
                    effect: 'fade',
                    fadeEffect: {
                        crossFade: true
                    },
                    // If we need pagination
                    pagination: {
                        el: '.swiper-pagination',
                        type: 'bullets',
                        clickable: true
                    },
                    watchOverflow: true
                });
                $(this).removeClass('swiper-autoplay-init');
                $(this).on('mouseenter', function() {
                    autoplaySwiper.autoplay.stop();
                });
                $(this).on('mouseleave', function() {
                    autoplaySwiper.autoplay.start();
                });
            }
        });
    };
    const initBrandsCarousel = function() {
        brandsCarousel = new Swiper('.brands-carousel .swiper-carousel', {
            autoplay: {
                delay: swiperDelay,
            },
            spaceBetween: 30,
            navigation: {
                nextEl: '.swiper-button-next--desktop',
                prevEl: '.swiper-button-prev--desktop',
            },
            pagination: {
                el: '.swiper-pagination--desktop',
                clickable: true,
            },
            breakpoints: {
                0: {
                    slidesPerView: 1,
                    spaceBetween: 20,
                },
                768: {
                    slidesPerView: 4,
                    spaceBetween: 40,
                },
                1200: {
                    slidesPerView: 6,
                    spaceBetween: 50,
                },
            },
            watchOverflow: true
        });
        $('.brands-carousel .swiper-carousel .swiper-wrapper').css('transform','');
    };

    const initBrandsCarouselMobile = function() {
        brandsCarouselMobile = new Swiper('.brands-carousel--mobile .swiper-carousel', {
            autoplay: {
                delay: swiperDelay,
            },
            spaceBetween: 30,
            navigation: {
                nextEl: '.swiper-button-next--mobile',
                prevEl: '.swiper-button-prev--mobile',
            },
            pagination: {
                el: '.swiper-pagination--mobile',
                clickable: true,
            },
            slidesPerView: 1,
            watchOverflow: true
        });
        $('.brands-carousel--mobile .swiper-carousel .swiper-wrapper').css('transform','');
    };
    const brandsCarouselPreInit = function() {
        if (window.innerWidth < 768) {
            if (brandsCarousel !== 'undefined') {
                brandsCarousel.destroy(true,true);
                brandsCarousel = 'undefined';
            }
            if (brandsCarouselMobile === 'undefined') {
                initBrandsCarouselMobile();
            }
        } else {
            if (brandsCarouselMobile !== 'undefined') {
                brandsCarouselMobile.destroy(true,true);
                brandsCarouselMobile = 'undefined';
            }
            if (brandsCarousel === 'undefined') {
                initBrandsCarousel();
            }
        }
    };
    $(window).resize(function() {
        brandsCarouselPreInit();
    });
    const initSwipersInterval = setInterval(function() {
        if ($('.hero-banner .swiper-slide').length > 0) {
            if ($('.hero-banner .swiper-slide img').hasClass('lazyloaded')) {
                initSwipers();
                brandsCarouselPreInit();
                setTimeout(function() {
                    $('.hero-banner .lazyloading').addClass('lazyloaded')
                        .removeClass('lazyloading');
                },300);
                clearInterval(initSwipersInterval);
            }
        } else {
            initSwipers();
            brandsCarouselPreInit();
            clearInterval(initSwipersInterval);
        }
    }, 100);

    const scentsCarousel = new Swiper('.scents-of-the-month-carousel .swiper-carousel', {
        autoplay: {
            delay: swiperDelay,
        },
        spaceBetween: 30,
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
        breakpoints: {
            0: {
                slidesPerView: 2,
                spaceBetween: 20,
            },
            768: {
                slidesPerView: 3,
                spaceBetween: 40,
            },
        },
        watchOverflow: true
    });
    const variationsCarousel = new Swiper('.variations-carousel .swiper-carousel', {
        autoplay: {
            delay: swiperDelay,
        },
        spaceBetween: 30,
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
        breakpoints: {
            0: {
                slidesPerView: 2,
                spaceBetween: 20,
            },
            768: {
                slidesPerView: 4,
                spaceBetween: 15,
            },
        },
        watchOverflow: true
    });

    const scrollToTarget = function(tgtEl, siteHeader) {
        const scrollSpeed = 500;
        // is header fixed?
        let hoffset = 0;
        if (!siteHeader) {
            if (siteHeader.css('position') === 'fixed' || siteHeader.css('position') === 'sticky') {
                hoffset = siteHeader.height() + 50;
            }
        }
        if (tgtEl.parent().css('display') !== 'none') {
            const scrollToHere = tgtEl.offset().top - hoffset;
            $('html, body').animate({
                scrollTop: scrollToHere
            }, scrollSpeed);
        }
    };

    $('a.scrollToTgt[href^="#"]').on('click', function(e) {
        e.preventDefault();
        let tgtEl;
        if ($(this).attr('href').length > 1) {
            if ($(this).attr('href') === '#back_to_top') {
                tgtEl = $('body');
            } else {
                tgtEl = $($(this).attr('href'));
            }
            const siteHeader = $('.site-header');

            scrollToTarget(tgtEl, siteHeader);
        }
    });
    $('.quick_buy_button').on('click',function(e) {
        e.preventDefault();
        const tgt = $(this).attr('href');
        $('.modal--active').removeClass('modal--active');
        $(tgt).addClass('modal--active');
        $('body').addClass('page-overlay--on');
    });
    $('.close-modal').on('click',function() {
        $(this).parent()
            .removeClass('modal--active');
        $('body').removeClass('page-overlay--on');
    });
    $('.product-modal-content').each(function() {
        const ajaxBtn = $(this)
            .find('.ajax_add_to_cart');
        ajaxBtn.text('ADD TO BASKET');
        $(this).find('input.qty')
            .after(ajaxBtn);
        $(this).find('.single_add_to_cart_button')
            .remove();
    });
    $('.product-modal-content .ajax_add_to_cart').on('click',function() {
        const qty = $(this)
            .parent()
            .find('input.qty')
            .val();
        $(this).attr('data-quantity',qty);
    });

    // Footer nav mobile toggles
    const footerChevron = '<span class="footer-nav-toggle"><i class="far fa-chevron-down"></i></span>';
    $('.footer-menu .menu-item-has-children > a').after(footerChevron);
    $('.footer-nav-toggle').on('click', function() {
        const subMenu = $(this).parent()
            .find('.sub-menu');
        const menuParent = $(this).parent()
            .parent();
        $('.footer-nav-toggle.active').not($(this))
            .trigger('click');
        $(this).toggleClass('active');
        menuParent.toggleClass('footer-nav--open');
        subMenu.toggleClass('footer-nav--open');
    });

    // Move modals outside of swiper.
    if ($('.swiper-carousel .product-modal-content').length > 0) {
        $('footer.site-footer').after('<div class="woocommerce footer-product-modals"><div class="product"></div></div>');
        $('.swiper-carousel .product-modal-content').appendTo($('.footer-product-modals'));
    }
};

export default common;
