<?php

$brandOptionTransient = get_transient('brandOptions');

if (!$brandOptionTransient) {
    ob_start();
    $brand = get_field('brand');
    if (!$brand) {
        $brand = get_the_terms(get_the_id(), 'brand');
        if ($brand && count($brand) > 0) {
            $brand = $brand[0];
        }
    }

    if (!$brand) {
        $brand = get_field('default_department', 'option');
    }

    // Get top level parent of this Brand.
    if ($brand) {

        $ancestors = get_ancestors($brand->term_id, 'brand');
        if (count($ancestors) > 0) {
            $ancestors = array_reverse($ancestors);
            $ancestors[0] ? $topTermId = $ancestors[0] : $topTermId = $brand;
        } else {
            $topTermId = $brand;
        }


        $topTerm = get_term($topTermId, 'brand');

        $subBrandArgs = [
            'hierarchical' => 1,
            'show_option_none' => '',
            'hide_empty' => 0,
            'parent' => $topTerm->term_id,
            'taxonomy' => 'brand'
        ];

        $subBrands = get_categories($subBrandArgs);
        $subBrandArgs = array(
                'meta_key' => '_wp_page_template',
                'meta_value' => 'template-brand.php',
                'hierarchical' => 0,
                'post_status'  => 'publish'
        );
        $subBrandPages = get_pages($subBrandArgs);
        $brandPageTermIDs = [];
        foreach ($subBrandPages as $subBrandPage) {
            array_push($brandPageTermIDs, get_field('brand',$subBrandPage->post_id)->term_id);
        }
        
        ?>
        <section class="brands-carousel content-container text-center">
            <?php if ($subBrands) { ?>
                <h2>Brands to explore</h2>
                <div class="swiper-carousel">
                    <div class="swiper-wrapper">

                        <?php foreach ($subBrands as $subBrand) {
                            $brandIndex = array_search($subBrand->term_id, $brandPageTermIDs);
                            if($brandIndex !== FALSE){
                                $subBrandPages[$brandIndex];
                                $subBrandLink = get_permalink($subBrandPages[$brandIndex]->post_id);
                            }else{
                                $subBrandLink = "/brand/" . $subBrand->slug;
                            }
                            $image = get_field('brand_featured_image', 'brand_' . $subBrand->term_id);
                            $size = 'medium';
                            $thumb = $image['sizes'][ $size ];
                            ?>
                            <div class="swiper-slide">
                                <a href="<?= $subBrandLink; ?>">
                                    <div class="img-wrapper img-round">
                                        <img class="img-fluid" src="<?php echo esc_url($thumb); ?>"
                                             alt="<?= $image['title']; ?>">
                                    </div>
                                    <p><?= $subBrand->name; ?></p>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="swiper-pagination swiper-pagination--desktop"></div>
                </div>
                <div class="swiper-button-prev swiper-button-prev--desktop"></div>
                <div class="swiper-button-next swiper-button-next--desktop"></div>
            <?php } ?>
        </section>
    <?php }
    $brandsCarousel = ob_get_clean();
    set_transient('brandOptions', $brandsCarousel, 1 * DAY_IN_SECONDS);
    return $brandsCarousel;

} else {
    echo $brandOptionTransient;
}
?>