<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
$brand_list = wp_get_post_terms($post->ID, 'brand', ['fields' => 'all']);
foreach($brand_list as $term) {
    if( get_post_meta($post->ID, '_yoast_wpseo_primary_brand',true) == $term->term_id ) {
        $brand = $term;
    }
}

$scent_list = wp_get_post_terms($post->ID, 'scent', ['fields' => 'all']);
foreach($scent_list as $term) {
    if( get_post_meta($post->ID, '_yoast_wpseo_primary_scent',true) == $term->term_id ) {
        $scent = $term;
    }
}
// Fallback scent.
if(!$scent){
    $scent = $scent_list[0];
}
$isGiftCard = $product->slug == 'gift-card';
/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}
?>
<?php
/*
if ( function_exists('yoast_breadcrumb') ) {
  yoast_breadcrumb( '<p id="breadcrumbs">','</p>' );
}
*/
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
    <div class="d-block d-lg-none text-left"><?php woocommerce_template_single_title();?></div>
    <?php
    /**
     * Hook: woocommerce_before_single_product_summary.
     *
     * @hooked woocommerce_show_product_sale_flash - 10
     * @hooked woocommerce_show_product_images - 20
     */
    do_action( 'woocommerce_before_single_product_summary' );
    $brand = get_the_terms(get_the_id(), 'brand');
    $myBrand = $brand[0];
    // Test to make sure we're not using the Department as the Brand.
    $parent = ( isset( $myBrand->parent ) ) ? get_term_by( 'id', $myBrand->parent, 'brand' ) : false;
    if(!$parent){
        $myBrand = $brand[1];
    }

    $brand_bg = get_field('brand_featured_image','brand_'.$myBrand->term_id);

    $mainBrand = get_ancestors($myBrand->term_id, 'brand');
    if (count($mainBrand) > 1) {
        $mainBrand = array_reverse($mainBrand);
        if(!$brand_bg){
            $brand_bg = get_field('brand_featured_image','brand_'.$mainBrand[1]);
        }
        //$mainBrand = get_term_by( 'id', $mainBrand[1], 'brand' );
    }

    // Get term names
    $brandTerms = Array();
    foreach ($brand as $brandTerm){
        if($brandTerm->name !== $parent->name && $brandTerm->name !== 'Casa Candles'){
            Array_push($brandTerms,$brandTerm->name);
        }
    }
    ?>
    <section class="product-details">
        <div class="summary entry-summary">
            <?php //woocommerce_template_single_title();?>
            <?php
            /**
             * Hook: woocommerce_single_product_summary.
             *
             * @hooked woocommerce_template_single_title - 5
             * @hooked woocommerce_template_single_rating - 10
             * @hooked woocommerce_template_single_price - 10
             * @hooked woocommerce_template_single_excerpt - 20
             * @hooked woocommerce_template_single_add_to_cart - 30
             * @hooked woocommerce_template_single_meta - 40
             * @hooked woocommerce_template_single_sharing - 50
             * @hooked WC_Structured_Data::generate_product_data() - 60
             */
            ?>
            <div class="d-none d-lg-block">
                <div class="brand">
                    <a href="<?= get_category_link($myBrand->term_id); ?>"><?= $myBrand->name; ?></a>
                </div>
                <?php
                woocommerce_template_single_title();
                ?>
            </div>
            <?php
            woocommerce_template_single_rating();
            woocommerce_template_single_price();

            if( has_term( array( 'sale' ), 'product_cat', $product->get_id() ) || has_term( array( 'Sale' ), 'product_cat', $product->get_id() )) {
                echo '<span class="sale-tag">Sale</span>';
            }
            woocommerce_template_single_excerpt();


            $currentPage = get_the_id();
            $args = array(
                'post_type' => 'product',
                'tax_query' => array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' => 'scent',
                        'field'    => 'name',
                        'terms'    => $scent->name,
                        'operator' => 'IN',
                    ),
                    array(
                        'taxonomy' => 'brand',
                        'field'    => 'name',
                        'terms'    => $brandTerms,
                        'operator' => 'IN',
                    ),
                ),
            );
            //$my_query = new WP_Query( $args );
            $posts = get_posts( $args );
            ?>

            <section class="variations-carousel">
                <?php if( $posts ){ ?>
                    <p><strong>Variations:</strong></p>
                    <div class="swiper-carousel">
                        <div class="swiper-wrapper">

                            <?php foreach( $posts as $post ):
                                if($post->ID !== $currentPage){
                                    $image = get_the_post_thumbnail_url(get_the_id(),'large');
                                    $brandSlug = str_replace('-', ' ', $brand->slug);
                                    $title = get_the_title();
                                    $title = strtolower(html_entity_decode($title));
                                    $title = str_replace('&', '&amp;', $title);
                                    $search  = array(strtolower($brand->name),strtolower($scent->name),$brandSlug);
                                    $replace = array('', '');
                                    $subject = $title;
                                    $title = str_replace($search, $replace, $subject);
                                    ?>
                                    <div class="swiper-slide">
                                        <a href="<?= the_permalink();?>">
                                            <div class="img-wrapper img-wrapper--square">
                                                <img class="img-fluid" src="<?=$image;?>" alt="<?=$post->title;?>">
                                            </div>
                                            <p><?=$title;?></p>
                                        </a>
                                    </div>
                                    <?php
                                }
                            endforeach;
                            ?>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                    <?php
                } ?>
            </section>
            <?php
            //wp_reset_query();


            woocommerce_template_single_add_to_cart();
            woocommerce_template_single_sharing();
            //WC_Structured_Data::generate_product_data()
            //do_action( 'woocommerce_single_product_summary' );
            ?>
        </div>

        <?php
        /**
         * Hook: woocommerce_after_single_product_summary.
         *
         * @hooked woocommerce_output_product_data_tabs - 10
         * @hooked woocommerce_upsell_display - 15
         * @hooked woocommerce_output_related_products - 20
         */
        woocommerce_output_product_data_tabs();
        // woocommerce_output_related_products();
        //do_action( 'woocommerce_after_single_product_summary' );
        ?>
    </section>
</div>
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>

<?php
// Brands panel

$args = array(
    'post_type' => 'product',
    'post_status'  => 'publish',
    'exclude' => $currentPage,
    'tax_query' => array(
        array(
            'taxonomy' => 'brand',
            'field'    => 'name',
            'terms'    => $myBrand->name,
            'operator' => 'IN'
        )
    ),
    'posts_per_page' => 3
);
$my_posts = get_posts( $args );

if($mainBrand[1] === NULL){
    $brandLogo = get_field('brand_logo','brand_'.$myBrand->term_id);
    $mainBrandTerm = $myBrand;
}else{
    $brandLogo = get_field('brand_logo','brand_'.$mainBrand[1]);
    $mainBrandTerm = get_term( $mainBrand[1], 'brand' );
}
if($brandLogo){
    $size = 'medium';
    $brandLogoUrl = $brandLogo['sizes'][ $size ];
}
if($myBrand) {
    ?>
    <section class="related-products-row row-tint upsells-row content-container text-center flex-wrap">
        <div class="row">
            <div class="brand-description-row section__intro">
                <?php
                if ($brandLogoUrl) {
                    ?>
                    <div class="band-logo">
                        <div class="img-wrapper img-round">
                            <img src="<?= $brandLogoUrl; ?>" alt="<?= $myBrand->name; ?>">
                        </div>
                    </div>
                    <?php
                }

                ?>
                <h2><?= $mainBrandTerm->name; ?></h2>
                <p><?= $mainBrandTerm->description; ?></p>
            </div>
        </div>
        <?php if ($my_posts) {
            ?>
            <div class="row--products flex-row">
                <ul class="up-sells upsells products">
                <?php foreach ($my_posts as $post):
                        $product = wc_get_product($post->ID);
                        wc_get_template_part('content', 'product');
                        ?>

                        <?php
                endforeach;
                ?>
                </ul>
            </div>
            </div>
            <?php wp_reset_postdata();
        } ?>
    </section>
    <?php
}

if($myBrand) { ?>
<section class="image-bg-row img-framed text-center">
    <div class="image__bg" style="background-image:url(<?=$brand_bg['url'];?>)">
    </div>
    <a class="cover-link" href="/brand/<?=$myBrand->slug;?>">
            <span class="btn btn-primary" href="/brand/<?=$myBrand->slug;?>">
                View all <?=$myBrand->name;?>
            </span>
    </a>
</section>
<?php } ?>


<section class="flex row-tint">
    <?php
    get_template_part('templates/parts/brands-carousel');
    ?>
</section>

<?php
//woocommerce_upsell_display();
$fragranceFams = wc_get_product_terms( $product->id, 'pa_fragrance-family', array( 'fields' => 'slugs' ) );
$args = array(
    'posts_per_page'      => 3,
    'fields'              => 'ids',
    'post_type'           => 'product',
    'post_status'         => 'publish',
    'ignore_sticky_posts' => true,
    'suppress_filters'    => true,
    'no_found_rows'       => 1,
    'orderby'             => 'rand',
    'order'               => 'DESC',
    'lang'                => '',
    'tax_query'           => array(
        array(
            'taxonomy'            => 'pa_fragrance-family',
            'field'               => 'slug',
            'terms'               => $fragranceFams,
            'operator'            => 'IN',
            'include_children' => true
        )
    )
);

$relatedProducts = new WP_Query( $args );
if($relatedProducts->have_posts()) { ?>
    <section class="upsells-row content-container text-center flex-wrap">
        <h2>You may also like</h2>
        <div class="up-sells upsells products">
            <ul class="products columns-4">
                <?php while ( $relatedProducts->have_posts() ) {
                    $relatedProducts->the_post();
                    $product_ids[] = $relatedProducts->post->ID;
                    wc_get_template_part('content', 'product');
                }
                wp_reset_postdata();
                ?>
            </ul>
        </div>
    </section>
<?php } ?>



<div class="leave-a-review-bar row">
    <div class="average-product-score col-12 col-sm-4 offset-sm-4">
        <?php
            global $product;
            $id = $product->id;
            $rpage = 1;
            $limit = 2;
            $offset = ($rpage * $limit) - $limit;
            $rcount = wp_count_comments($id);
            $rcount = $rcount->approved;

            $args = [
                'number'      => $limit,
                'offset'      => $offset,
                'status'      => 'approve',
                'post_status' => 'publish',
                'post_type'   => 'product',
                'post_id' => $id
            ];
            $reviews = get_comments( $args );
            $rating  = $product->get_average_rating();
            if ( $reviews) {
        ?>
        <p><span><?=(float)$rating;?> </span>average rating</p>
        <div class="stars-wrapper">
            <?php woocommerce_template_loop_rating();?>
        </div>
        <?php
            }
        ?>
    </div>
    <?php if(is_user_logged_in()) { ?>
    <div class="col-12 col-sm-4">
        <a href="" class="review-form-trigger" data-toggle="modal" data-target="#reviewModal">Write a review</a>
        <div class="modal fade" id="reviewModal" tabindex="-1" role="dialog" aria-labelledby="reviewModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="reviewModalLabel">Product Review</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <h3>Review of <?= get_the_title(); ?></h3>
                        <?php get_template_part('templates/sections/custom-review-form'); ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php } ?>
</div>

<?php
if ( $reviews) { ?>
    <div class="custom-review-output">
        <div class="inner-reviews">

            <?php foreach ($reviews as $review) {
                $date = date('d F Y', strtotime($review->comment_date));
                $rating = intval( get_comment_meta( $review->comment_ID, 'rating', true ) );
                ?>
                <div class="custom-review-item">
                    <div class="row">
                        <div class="col-lg-3 primary-output">
                            <div class="name">   <?= $review->comment_author; ?></div>
                            <?php if ( $rating && wc_review_ratings_enabled() ) { ?>
                                <div class="rating">
                                    <?= wc_get_rating_html( $rating ); ?>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="col-lg-6 comment-output"><?= $review->comment_content; ?></div>
                        <div class="col-lg-3 date-output"><?= $date; ?></div>
                    </div>
                </div>

            <?php } ?>
        </div>
    </div>
    <?php
        $rpage = get_query_var('rpage') ? get_query_var('rpage') : 1;

if( $rcount > $limit ) {
?>
<div class="text-center"><div class="reviews_loadmore">Load More</div></div>
<script type="text/javascript">
//var myajaxurl = '<?=site_url('wp-admin/admin-ajax.php');?>';
var	parent_post_id = <?=get_the_ID();?>;
var rpage = <?=$rpage?>;
jQuery( document ).ready(function() {
     // load more button click event
    jQuery('.reviews_loadmore').click( function() {
        var button = jQuery(this);
        // decrease the current comment page value
        rpage--;
        jQuery.ajax({
            url : ajaxurl, // AJAX handler, declared before
            data : {
                'action': 'cloadmore', // wp_ajax_cloadmore
                'post_id': parent_post_id, // the current post
                'rpage' : rpage, // current comment page
                'limit' : <?=$limit;?>,
            },
            type : 'POST',
            beforeSend : function (xhr) {
                button.text('Loading...'); // preloader here
            },
            success : function(data) {
                console.log('"'+data+'"');
                if(data) {
    				jQuery('.inner-reviews').append(data);
					button.text('Load More');
                    // if the last page, remove the button
                    if (data == '<div class="custom-review-item custom-review-item--noreviews">No more reviews</div>    ') {
    					button.remove();
                    }
                } else {
                    button.remove();
                }
            }
        });
        return false;
    });
});
</script>
<?php
}
?>
<?php } ?>


