<?php
$brand = get_field('brand');
$promos = get_field('promoted_categories');
if($promos && $brand) {

    if ($promos['introduction_text'] || $promos['brand_categories']) {

        ?>
        <section class="promoted-categories content-container">
            <div class="row">
                <div class="section__intro">
                    <?= $promos['introduction_text']; ?>
                </div>
            </div>
            <div class="row flex-row row-wrap">
                <?php
                // Grab default scent image from scent tax.
                //Look for product cats in popular cats repeater.
                $promo_cats = $promos['brand_categories'];

                if ($promo_cats) {
                    foreach ($promo_cats as $promo_cat) {
                        $collections = $promo_cat['show_collections'];
                        if ($collections) {
                            $term = $promo_cat['collection'];
                            $tax = 'brand_';
                        } else {
                            $term = $promo_cat['category'];
                            $tax = 'product_cat_';
                        }
                        $imageUrl = null;
                        // Look for Category images with fallbacks.
                        // Get default Cat image
                        $thumbnail_id = get_term_meta($term->term_id, 'thumbnail_id', true);
                        $imageUrl = wp_get_attachment_url($thumbnail_id);

                        //Get image from Cat or Brand
                        if ($collections) {
                            $image = get_field('brand_featured_image', $tax . $term->term_id);
                            if ($image) {
                                $imageUrl = $image['url'];
                            }
                        } else {
                            $catImgRows = get_field('category_image_by_brand', $tax . $term->term_id);
                            if ($catImgRows) {
                                foreach ($catImgRows as $catImgRow) {
                                    if ($catImgRow['brand']->name == $brand->name) {
                                        $image = $catImgRow['brand_category_image'];
                                        $imageUrl = $image['url'];
                                        break;
                                    }
                                }
                            }
                        }

                        // Get image from page if set.
                        if ($promo_cat['image']) {
                            $image = $promo_cat['image'];
                            $imageUrl = $image['url'];
                        }
                        if ($collections) {
                            $link = esc_url(get_term_link($term));
                        } else {
                            $link = $link = '/product-category/'.$term->slug.'?swoof=1&brand='.$brand->slug.'&product_cat='.$term->slug; //'/index.php?post_type=product&brand=' . $brand->slug . '&product-category=' . $term->slug;
                        }
                        $excerpt = mb_strimwidth(esc_html($term->description), 0, 50, '...');
                        ?>
                        <div class="cat-panel col text-center">
                            <a href="<?= $link; ?>">
                                <div class="img-wrapper img-framed">
                                    <img class="img-fluid" src="<?= $imageUrl; ?>" alt="<?= $term->name; ?>">
                                </div>
                                <h2><?php echo esc_html($term->name); ?></h2>
                                <p><?= $excerpt; ?></p>
                            </a>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
        </section>
        <?php
    }
}
?>