<?php
$bgimg = get_field('footer_background_image','option');
$rows = get_field('icon_captions','option');
if( is_array($rows) ) {
    ?>
    <section class="icon-caption-row row-tint">
        <div class="content-container text-center">
            <div class="row">
                <?php
                foreach( $rows as $row ) {
                    ?>
                    <div class="col-md">
                        <i class="fa<?=$row['icon'];?>"></i>
                        <p><?=$row['caption'];?></p>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
    </section>
    <?php
}
?>
</section>
<div class="page-overlay"></div>
<footer class="site-footer">
    <div class="footer-bg" <?php if($bgimg){
        ?>
        style="background-image:url(<?=$bgimg;?>);"
        <?php
    }
    ?>></div>
    <div class="footer-content container-fluid">
        <div class="row">
            <nav class="social-media col-md-4">
                <div class="newsletter">
                    <!-- Begin Mailchimp Signup Form -->
                    <link href="//cdn-images.mailchimp.com/embedcode/horizontal-slim-10_7.css" rel="stylesheet" type="text/css">
                    <div id="mc_embed_signup">
                        <form action="https://casacandles.us4.list-manage.com/subscribe/post?u=d1b3516dea2ce7b5f404ef446&amp;id=c77a838f81" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate" target="_blank" novalidate>
                            <div id="mc_embed_signup_scroll">
                                <label for="mce-EMAIL">Join our newsletter</label>
                                <div class="mc-form-elements">
                                    <input type="email" value="" name="EMAIL" class="email" id="mce-EMAIL" placeholder="Email address" required>
                                    <!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->
                                    <div style="position: absolute; left: -5000px;" aria-hidden="true"><input type="text" name="b_d1b3516dea2ce7b5f404ef446_c77a838f81" tabindex="-1" value=""></div>
                                    <div class="clear">
                                    <span class="subscribe-btn">
                                        <i class="far fa-arrow-right"></i>
                                        <input type="submit" value="Subscribe" name="subscribe" id="mc-embedded-subscribe" class="button">
                                    </span>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!--End mc_embed_signup-->
                </div>
                <?php if (have_rows('social_media_channels', 'option')) { ?>

                    <?php
                    while (have_rows('social_media_channels', 'option')) {
                        the_row();
                        ?>
                        <a href="<?php the_sub_field('full_url'); ?>" target="_blank" rel="noopener"><i class="<?php the_sub_field('fa5_icon_class'); ?>"></i></a>
                        <?php
                    }
                    ?>

                <?php } ?>
            </nav>
            <nav class="navigation col-md-8">
                <?php

                $departmentArgs = array(
                    'parent' => 0,
                    'hide_empty' => 0,
                );
                $departments = get_terms(
                    'brand',
                    $departmentArgs
                );
                $departmentPageArgs = array(
                    'meta_key' => '_wp_page_template',
                    'meta_value' => 'template-department.php',
                    'hierarchical' => 0,
                    'post_status'  => 'publish'
                );
                $departmentPages = get_pages($departmentPageArgs);
                $departmentPageIDs = [];
                foreach ($departmentPages as $departmentPage) {
                    array_push($departmentPageIDs, get_field('brand',$departmentPage->post_id)->term_id);
                }
                ?>
                <ul class="nav--departments">
                    <li><a href="<?php echo esc_url(home_url('/')); ?>">Casa World</a><span class="footer-nav-toggle"><i class="far fa-chevron-down"></i></span></li>
                    <?php
                    echo '';
                    if ($departments){
                        $i=0;
                        foreach ($departments as $department) {

                            $i++;
                            $maintenance = get_field('maintenance', 'brand_'.$department->term_id);
                            $link_overlay = get_field('link_overlay', 'brand_' .$department->term_id);
                            if($maintenance){
                                $departmentUrl = '';
                                $linkClasses = 'maintenance--on';
                            }else{

                                $linkClasses = '';
                                $departmentIndex = array_search($department->term_id, $departmentPageIDs);
                                if($departmentIndex !== FALSE){
                                    $departmentUrl = get_permalink($departmentPages[$departmentIndex]->post_id);
                                }else{
                                    $departmentUrl = get_category_link($department->term_id);
                                }
                            }

                            ?>
                            <li><a class="<?=$linkClasses;?>" href="<?=$departmentUrl;?>"><?=$department->name;?><?php if($maintenance){?><span class="cat-overlay"><?=$link_overlay;?></span><?php }; ?></a></li>
                            <?php
                        }
                        echo '</ul>';
                    }
                    ?>
                    <?php
                    if (has_nav_menu( 'footer_menu' )) {
                        wp_nav_menu(['theme_location' => 'footer_menu', 'menu_class' => 'footer-menu']);
                    }
                    ?>
            </nav>
        </div>
        <div class="bottom-footer-row row">

            <div class="footer-payment options order-lg-2 col-lg-6">
                <?php $paymentOptions = get_field('footer_payment_options', 'option');
                if($paymentOptions) { ?>
                    <ul>
                        <?php foreach($paymentOptions as $option) { ?>
                            <li><img src="<?= $option['image']['url']; ?>" alt="<?= $option['title']; ?>" title="<?= $option['title']; ?>"></li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>

            <div class="copyright col-6 order-lg-1 col-lg-3">
                <p>&copy; <?php echo date("Y"); ?> <?php bloginfo('name'); ?></p>
            </div>

            <div class="credit col-6 order-lg-3 col-lg-3">
                <p>Website by</p>
                <?php echo do_shortcode( '[blue2_logo type="light"]' ); ?>
            </div>
        </div>
    </div>
</footer>
