<?php

$scentsTransient = get_transient('scentsOfTheMonth');
$currentPage = get_the_id();

if (!$scentsTransient) {
    ob_start();
    $brand = get_field('brand', $currentPage);

    $currentBrand = get_the_id();

    if (!$brand) {
        $brand = get_field('brand', wp_get_post_parent_id($post));
        $currentBrand = wp_get_post_parent_id($post);
    }

    $args = [
        'taxonomy' => 'brand',
        'post_status' => 'publish',
    ];

    $brands = get_terms($args);


    $scentsIntro = '<h2>Discover scents of the month</h2>';
    ?>

    <section class="scents-of-the-month-carousel content-container text-center">
        <?php if ($brands) { ?>
            <div class="section__intro">
                <?= $scentsIntro; ?>
            </div>
            <div class="scents__carousel-wrapper">
                <div class="swiper-carousel">
                    <div class="swiper-wrapper">
    
                        <?php foreach ($brands as $thePost) {
                            if ($thePost->ID !== $currentPage) {
                                $scents = get_field('scent_of_the_month', 'brand_' . $thePost->term_id);
                                if ($scents) {
                                    foreach ($scents as $scent) {
                                        $title = $scent->name;
                                        // Grab default scent image from scent tax.
                                        $image = get_field('scent_featured_image', 'scent_' . $scent->term_id); 
                                        $size = 'large';
                                        $thumb = $image['sizes'][ $size ];
                                        ?>
                                        <div class="swiper-slide">
                                            <a href="<?= get_category_link($scent->term_id); ?>">
                                                <div class="img-wrapper">
                                                    <img class="img-fluid" src="<?php echo esc_url($thumb); ?>"
                                                         alt="<?= $thePost->title; ?>">
                                                </div>
                                                <p><?= $title; ?></p>
                                            </a>
                                        </div>
                                        <?php
                                    }
                                }
                            }
                        }
                        ?>
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
                <div class="swiper-button-prev"></div>
                <div class="swiper-button-next"></div>
            </div>
            <?php
        } ?>
    </section>
    <?php
    $scentData = ob_get_clean();
    set_transient('scentsOfTheMonth', $scentData, 1 * DAY_IN_SECONDS);
    echo $scentData;
} else {
    echo $scentsTransient;
}
?>