<?php
    $brand = get_field('brand');
    $scents = get_field('scent_of_the_month','brand_'.$brand->term_id);
    
    if(get_field('select_scents') == true){
        $scents = get_field('scent_of_the_month');
    }
    
    // Get top level parent of this Brand.
    $ancestors = get_ancestors( $brand->term_id, 'brand' ); 
    $ancestors = array_reverse($ancestors);
    $ancestors[0] ? $top_term_id = $ancestors[0] : $top_term_id = $brand;
    $term = get_term( $top_term_id, 'brand' );
    $parentBrand = $term->name;
    
    $banner = get_field('banner_images');
    ?>
<div class="brand-landing-page">
    <div class="hero-banner">
        <?php if( have_rows('banner_images') ): ?>
            <div class="hero-banner__slides swiper-container swiper-container--paused">
                <div class="swiper-wrapper">      
                <?php while( have_rows('banner_images') ): the_row(); 
                    $image = get_sub_field('banner_image');
                    ?>
                    <div class="swiper-slide">
                        <img src="<?=$image['url'];?>" alt="<?=$image['title'];?>">
                    </div>
                <?php endwhile; ?>
                </div>
                <div class="swiper-pagination"></div>
            </div>
        <?php endif; ?>
    </div>
    <div class="section__intro">
        <div class="row">
            <div class="col-12 text-center">
                <?php
                    if ( function_exists('yoast_breadcrumb') ) {
                      yoast_breadcrumb( '<p id="breadcrumbs">','</p>' );
                    }
                    ?>
                    <h1><?php the_title();?>
                    </h1>
                <?php the_content();?>
            <br>
            </div>
        </div>
    </div>
</div>
                
<?php
$i=0;
if( $scents ): 
$makeSwiper = false;
if (count($scents)>1){
    $makeSwiper = false;// set to true to output multiple scent products in Swiper carousels;
}
foreach( $scents as $scent ): 
    if($i==1 || !$makeSwiper){
        $i=0;
?>
<div class="scent-row row-tint--alt" id="scent--<?=$scent->slug;?>">
    <?php
        }else{
            $i++
            ?>
            <div class="scent-row row-tint" id="scent--<?=$scent->slug;?>">
            <?php
        }
    ?>
    <div class="container">
        <div class="row">
            <div class="section__intro">
            <?=$scent->description;?>
        </div>
    </div>
</div>
    <section class="scent-of-the-month-grid woocommerce content-container products">
        <?php
             do_action( 'woocommerce_before_shop_loop' );
            $args = array(
            'post_type' => 'product',
            'post_status'  => 'publish',
            'posts_per_page' => -1,
            'tax_query' => array(
                array(
                    'taxonomy' => 'brand',
                    'field'    => 'name',
                    'terms'    => $brand->name,
                    'operator' => 'IN',
                ),
                array(
                    'taxonomy' => 'scent',
                    'field'    => 'name',
                    'terms'    => $scent->name,
                    'operator' => 'IN',
                ),
            ),
        );
        $query = new WP_Query( $args );
        
        if ( $query->have_posts() ) {
            if($makeSwiper){
            ?>
            <div class="scents-of-the-month-carousel">
                <div class="swiper-carousel">
                    <div class="swiper-wrapper products">
            <?php
            }else{
            ?>
             <div class="row flex-row flex-wrap">
            <?php
            }
                        while ( $query->have_posts() ) {
                            $query->the_post();
                            global $product;
                            if ( !empty( $product ) && $product->is_visible() ) {
                                if($makeSwiper){
                                ?>
                                <div class="swiper-slide">
                                    <ul>
                                <?php
                                }else{
                                ?>
                                <div class="col col-sm-6 col-md-4 cat-col">
                                    <ul class="cat-panel">
                                <?php
                                }
                                         do_action( 'woocommerce_shop_loop' );
                                         wc_get_template_part( 'content', 'product' );
                                 ?>
                                     </ul>
                                 </div>
                            <?php
                            }
                        }
                        if($makeSwiper){
                        ?>
                    </div>
                    <div class="swiper-pagination"></div>
                
                </div>  
                <div class="swiper-button-prev"></div>
                <div class="swiper-button-next"></div>
            </div>
            <?php 
                }else{
            ?>
            </div>
            <?php
                }       
            }
         wp_reset_postdata();
        ?>
    </section>
</div>
<?php 
    endforeach; 
endif; 
?>
<?php
    get_template_part('templates/parts/membership-cta');
?>  
  <?php
        get_template_part('templates/parts/scents-of-the-month-carousel');
    ?>
