<div id="review_form">
    <?php
    $commenter = wp_get_current_commenter();

    $comment_form = array(
        'title_reply'          => have_comments() ? __( '', 'woocommerce' ) : sprintf( __( '' ), get_the_title() ),
        'title_reply_to'       => __( '', 'woocommerce' ),
        'title_reply_before'   => '<span id="reply-title" class="comment-reply-title">',
        'title_reply_after'    => '</span>',
        'comment_notes_after'  => '',
        'fields'               => array(
            'author' => '<p class="comment-form-author">' . '<label for="author">' . esc_html__( 'Name', 'woocommerce' ) . '&nbsp;    <span class="required">*</span></label> ' .
                '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '"     size="30" aria-required="true" required /></p>',
            'email'  => '<p class="comment-form-email"><label for="email">' . esc_html__( 'Email', 'woocommerce' ) . '&nbsp;<span     class="required">*</span></label> ' .
                '<input id="email" name="email" type="email" value="' . esc_attr( $commenter['comment_author_email'] ) . '"     size="30" aria-required="true" required /></p>',
        ),
        'label_submit'  => __( 'Submit', 'woocommerce' ),
        'logged_in_as'  => '',
        'comment_field' => '',
    );

    if ( get_option( 'woocommerce_enable_review_rating' ) === 'yes' ) {
        $comment_form['comment_field'] = '<div class="comment-form-rating"><label for="rating">' . esc_html__( '',     'woocommerce' ) . '</label><select name="rating" id="rating" aria-required="true" required>
                                <option value="">' . esc_html__( 'Rate&hellip;', 'woocommerce' ) . '</option>
                                <option value="5">' . esc_html__( 'Perfect', 'woocommerce' ) . '</option>
                                <option value="4">' . esc_html__( 'Good', 'woocommerce' ) . '</option>
                                <option value="3">' . esc_html__( 'Average', 'woocommerce' ) . '</option>
                                <option value="2">' . esc_html__( 'Not that bad', 'woocommerce' ) . '</option>
                                <option value="1">' . esc_html__( 'Very poor', 'woocommerce' ) . '</option>
                            </select></div>';
    }

    $comment_form['comment_field'] .= '<p class="comment-form-comment"><label for="comment">' . esc_html__( 'Your review',     'woocommerce' ) . '&nbsp;<span class="required">*</span></label><textarea id="comment" name="comment" cols="45" rows="8"     aria-required="true" required></textarea></p>';

    comment_form( apply_filters( 'woocommerce_product_review_comment_form_args', $comment_form ) );
    ?>
</div>