<?php
$brand = get_field('brand');
// Get top level parent of this Brand.
$ancestors = get_ancestors($brand->term_id, 'brand');
$ancestors = array_reverse($ancestors);
if ($ancestors) {
    $ancestors[0] ? $top_term_id = $ancestors[0] : $top_term_id = $brand;
    $term = get_term($top_term_id, 'brand');
    $parentBrand = $term->name;
} else {
    $parentBrand = $brand->name;
}

$bannerColour = get_field('banner_text_colour');
$banner = get_field('banner_images');

$scents = get_field('scent_of_the_month');
?>
<div class="brand-landing-page">
    <?php
    get_template_part('templates/parts/hero-banner');
    get_template_part('templates/parts/promoted-row');
    get_template_part('templates/parts/scents-of-the-month-carousel');
    get_template_part('templates/parts/feature-row');
    get_template_part('templates/parts/brands-carousel');
    get_template_part('templates/parts/membership-cta');

    $instaFeed = get_field('instagram_shortcode', 'option');
    if ($instaFeed) {
        $instaTitle = get_field('instagram_title', 'option');
        $instaDesc = get_field('instagram_description', 'option'); ?>
        <section class="custom-insta-feed content-container">
            <?php if ($instaTitle) { ?><h2><a href="https://www.instagram.com/casa.world/"
                                              target="_blank"><?= $instaTitle; ?></a></h2><?php } ?>
            <?php if ($instaDesc) {
                echo $instaDesc;
            } ?>
            <?= get_field('instagram_shortcode', 'option'); ?>
        </section>
    <?php } ?>
</div>
