<?php
$queryObject = get_queried_object();
global $teamCounter;
$teamCounter = 1;
?>

<div class="custom-team-archive">
    <?php get_template_part('templates/sections/title-bar', null, [
        'title' => $queryObject->name,
        'description' => $queryObject->description
    ]); ?>

    <div class="archive-output">
        <div class="contain">
            <div class="row row-eq-height">
                <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
            </div>
            <div class="custom-pagination">
                <?php
                the_posts_pagination([
                    'mid_size' => 1,
                    'prev_text' => __('Previous', 'textdomain'),
                    'next_text' => __('Next', 'textdomain'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                ]); ?>
            </div>
        </div>
    </div>
</div>

<div class="team-overlay">
    <div class="team-wrapper">
        <div class="controls">
            <!-- todo - add functionality to left/right buttons -->
            <div class="navigation">
                <span class="fa-stack left-control">
                    <span class="fas fa-circle fa-stack-2x"></span>
                    <span class="fas fa-chevron-left fa-stack-1x custom-chevron"></span>
                </span>
                <span class="fa-stack right-control">
                    <span class="fas fa-circle fa-stack-2x"></span>
                    <span class="fas fa-chevron-right fa-stack-1x custom-chevron"></span>
                </span>
            </div>
            <div class="close u-case fw-700">
                Close <span class="fas fa-times"></span>
            </div>
        </div>
        <div class="content">
            <div class="title-holder">
                <h2 class="title">Alison Manson</h2>
                <h3 class="position">Senior Corporate Services Officer</h3>
            </div>
            <ul>
                <li class="email-holder">E: <a href="" class="email">alison.manson@carnegieuk.org</a></li>
                <li class="phone-holder">T: <a href="" class="phone">01383 721445</a></li>
            </ul>
            <div class="description">Alison joined the Carnegie UK Trust in June 2017 as Corporate Services Officer bringing with her over 20 years of experience.</div>
            <a href="" class="twitter-link">
                <span class="fa-stack">
                  <span class="fas fa-circle fa-stack-2x"></span>
                  <span class="fab fa-twitter fa-stack-1x custom-twitter"></span>
                </span>
            </a>
        </div>

        <?php
        $path = get_template_directory() . '/dist/images/icon.svg';
        $file = file_get_contents($path);

        // remove xml header
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );

        // add class and attributes for accessibility
        echo str_replace(
            '<svg',
            '<svg class="overlay-image" role="img" aria-label="The Carnegie UK Trust"',
            $file
        );
        ?>

    </div>
</div>

