<?php
$programmeContentTitle = get_field('programme_content_title', 'option');
$programmeContentDescription = get_field('programme_content_description', 'option');
?>
<div class="custom-programme-archive">
    <?php get_template_part('templates/sections/title-bar', null, [
        'title' => get_field('programme_archive_title', 'option'),
        'description' => get_field('programme_archive_description', 'option')
    ]); ?>


    <?php if($programmeContentDescription && $programmeContentTitle) { ?>
        <section>
            <div class="contain">
                <div class="archive-content-output">
                    <h2><?= $programmeContentTitle; ?></h2>
                    <div class="description"><?= $programmeContentDescription; ?></div>
                </div>
            </div>
        </section>
    <?php }?>

    <main class="archive-output">
        <div class="contain">
            <h2>Our Programmes</h2>
            <div class="programme-grid">
                <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
            </div>
            <div class="custom-pagination">
                <?php
                the_posts_pagination([
                    'mid_size' => 1,
                    'prev_text' => __('Previous', 'textdomain'),
                    'next_text' => __('Next', 'textdomain'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                ]); ?>
            </div>
        </div>
    </main>
</div>



