<?php
$title = get_sub_field('title');
$content = get_sub_field('content');
$quoteContent = get_sub_field('quote_content');
$sidebarImage = get_sub_field('sidebar_image');

$mainCol = $sidebarImage ? 'offset-lg-1 col-lg-8' : 'col-lg-12';
?>
<section class="inner-flexible-section block-quote">
    <div class="contain">
        <div class="row d-flex justify-content-center">
            <div class="col-xl-9">
                <div class="row">
                    <?php if($sidebarImage) { ?>
                        <div class="sidebar-col col-lg-3">
                            <img src="<?= $sidebarImage['url']; ?>" alt="<?= $sidebarImage['alt']; ?>">
                        </div>
                    <?php } ?>
                    <div class="content-col <?= $mainCol; ?>">
                        <div class="content-wrapper">
                            <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
                            <?php if($content) { ?><div class="description"><?= $content; ?></div><?php } ?>
                        </div>
                        <div class="quote-wrapper">
                            <div class="quote-container">
                                <div class="quote-icon"><span class="fas fa-quote-left"></span></div>
                                <div class="quote-content"><?= $quoteContent; ?></div>
                            </div>
                            <div class="svg-wrapper">
                                <?= \Blue2\Scruffy\Site::inlineSVG('/dist/images/icon-lightened.svg', 'quote-svg', 'Carnegie Logo') ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>