<?php

// Layout Modifiers
$showTwitterLogo = get_sub_field('show_twitter_logo_in_title');

// Section General Output
$sectionTitle = get_sub_field('section_title');
$twitterShortcode = get_sub_field('twitter_shortcode');
$socialLinks = get_field('social_media_channels', 'option');

// Get link to twitter from social channels.
$twitterLink = false;
foreach ($socialLinks as $socialLink){
    if($socialLink['platform'] === "fa-twitter"){
        $twitterLink = $socialLink['full_url'];
    }
} ?>
<div class="custom-flexible-section twitter-carousel-section">
    <div class="contain twitter-carousel-contain">
        <div class="row top-row">
            <div class="col-12 top-col">
                <h1><?php if($showTwitterLogo){ ?><i class="fab fa-twitter"></i><?php }?> <?= $sectionTitle ?></h1>
                <?php if($twitterLink) { ?>
                    <a class="twitter-link" href="<?= $twitterLink ?>">View Feed</a>
                <?php } ?>
            </div>
        </div>
        <div class="row content-row">
            <div class="col-12 twitter-col">
                <?= do_shortcode($twitterShortcode)?>
            </div>
        </div>
    </div>
</div>
