<?php
$title = get_sub_field('title');
$content = get_sub_field('content');
$sidebarContent = get_sub_field('sidebar_content');
$sidebarPosition = get_sub_field('sidebar_content_position');
?>
<div class="contain">
    <div class="row d-flex justify-content-center">
        <div class="col-xl-9">
            <section class="inner-flexible-section block-with-sidebar">
                <div class="row">
                    <div class="col-lg-4 sidebar-col">
                        <div class="sidebar-wrapper">
                            <div class="content"><?= $sidebarContent; ?></div>
                            <div class="svg-wrapper">
                                <?= \Blue2\Scruffy\Site::inlineSVG('/dist/images/icon-lightened.svg', 'sidebar-icon', 'Carnegie Logo') ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-8 content-col">
                        <div class="content-wrapper">
                            <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
                            <?php if($content) { ?><div class="description"><?= $content; ?></div><?php } ?>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>