<?php
global $teamCounter;
$position = get_field('position');
$email = get_field('email_address');
$twitter = get_field('position');
$phone = get_field('phone_number');
$description = wpautop(get_the_content());
$twitter = get_field('twitter');
$hideReadMore = get_field('disable_team_read_more_globally', 'option');
$postThumb = get_the_post_thumbnail( $post->ID , 'people-archive' ) ? get_the_post_thumbnail( $post->ID ,'people-archive' ) : '<img src="' . get_template_directory_uri() . '/dist/images/placeholder--team.png' . '" alt=""/>';
$postThumbUrl = get_the_post_thumbnail_url($post->ID, 'people-archive');
$readMoreTag = '<a title="' . get_the_title() . ' Info' . '" href="" class="people-read-more recordPersonEvent" data-id="' . $teamCounter++ . '" data-photo="' . $postThumbUrl . '" data-email="' . $email . '" data-phone="' . $phone . '" data-twitter="' . $twitter . '" data-position="' . $position . '" data-title="' .  get_the_title() . '" data-description="' . esc_html($description)  . '">';
?>
<div class="team-col col-sm-6 col-xl-4 col-xxl-3">
    <div class="team-inner <?= $hideReadMore ? 'read-more-disabled' : "team-item"; ?>">
        <div class="featured-image">
        <?php
            if(!$hideReadMore) { echo $readMoreTag; }
            echo $postThumb ;
            if(!$hideReadMore) { echo '</a>'; }
        ?>
        </div>
        <div class="team-details">
            <h2>
                <?php if(!$hideReadMore) { echo $readMoreTag; } ?>
                <?= get_the_title(); ?>
                <?php if(!$hideReadMore) { echo '</a>'; } ?>
            </h2>
            <?php if($position) { ?><h3><?= $position; ?></h3><?php } ?>
            <ul>
                <?php if($email) { ?><li>E: <a href="mailto:<?= $email; ?>"><?= $email; ?></a></li><?php } ?>
                <?php if($phone) { ?><li>T: <a href="tel:<?= $phone; ?>"><?= $phone; ?></a></li><?php } ?>
            </ul>
        </div>
    </div>
</div>


