<?php
$page_for_posts = get_option( 'page_for_posts' );

?>
<main>
    <?php if(get_the_id() == $page_for_posts) { ?>
        <div class="col-12">
            <div class="no-results-message"><?php the_field('no_results_message', 'option'); ?></div>
        </div>
    <?php } else { ?>
        <div class="standard-content-output">
            <?php get_template_part('templates/sections/title-bar', null, [
                'title' => get_the_title(),
                'description' => ''
            ]); ?>
            <?php if(get_field('flexible_sections')) { ?>
                <div class="flexible-layout inner-flexible-layout">
                    <?php Blue2\Scruffy\Utils::flexibleLoop('flexible_sections'); ?>
                </div>
            <?php } elseif(get_field('inner_flexible_sections')) { ?>
                <div class="inner-flexible-layout">
                    <div class="contain">
                        <div class="row d-flex justify-content-center">
                            <div class="col-xl-9">
                                <?php Blue2\Scruffy\Utils::flexibleLoop('inner_flexible_sections'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } else { ?>
                <div class="standard-content-output__contain contain">
                    <div class="row">
                        <div class="offset-lg-2 col-lg-8">
                            <?php the_content(); ?>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    <?php } ?>
</main>

