<?php

// Layout Modifiers
$showTwitter = get_sub_field('show_twitter_feed');
$enableDark = get_sub_field('enable_dark_theme') ? 'dark' : '';

// Post Selection
$args = array(
	'post_status' => 'publish'
);
// If the user sets the flag to manually select posts, the variable takes ACF post objects in an array, else it takes recent post array in an array.
$posts = get_sub_field('manually_select_posts') ? get_sub_field('manual_post_selection') : wp_get_recent_posts($args);

// Section General Output
$sectionTitle = get_sub_field('section_title');
$twitterTitle = get_sub_field('twitter_panel_title');
$twitterShortcode = get_sub_field('twitter_shortcode');
$postsTitle = get_sub_field('latest_posts_title');
$socialLinks = get_field('social_media_channels', 'option');

// Get link to twitter from social channels.
$twitterLink = false;
foreach ($socialLinks as $socialLink){
	if($socialLink['platform'] === "fa-twitter"){
		$twitterLink = $socialLink['full_url'];
	}
} ?>
<div class="custom-flexible-section latest-news-and-twitter-section <?= $enableDark ?>">
    <div class="contain latest-news-and-twitter-contain">
        <div class="row top-row">
            <div class="col-12 top-col">
                <h1><?= $sectionTitle ?></h1>
                <div class="button-container">
                    <div class="swipe-btn custom-post-button-prev"><i class="fas fa-arrow-left"></i></div>
                    <div class="swipe-btn custom-post-button-next"><i class="fas fa-arrow-right"></i></div>
                </div>
            </div>
        </div>
        <div class="row content-row <?php if($showTwitter){ ?>with-twitter<?php } ?>">
			<?php if($showTwitter){
				$class1 = "col-xl-7 col-xxl-8";
				$class2 = "latest-posts-swiper-twit" ?>
                <div class="col-xl-5 col-xxl-4 twitter-col">
                    <div class="wrapper top-wrapper">
                        <h2><?= $twitterTitle ?></h2>
                    </div>
                    <div class="wrapper bottom-wrapper">
						<?= do_shortcode($twitterShortcode)?>
                    </div>
                </div>
			<?php } else {
				$class1 = "col-xl-12";
				$class2 = "latest-posts-swiper";
			} ?>
            <div class="<?= $class1 ?> posts-col">
                <div class="wrapper top-wrapper">
                    <h2><?= $postsTitle ?></h2>
                </div>
                <div class="wrapper bottom-wrapper">
                    <div class="swiper-container <?= $class2 ?>">
                        <div class="swiper-wrapper">
							<?php
							// Loop through the post array to retrieve individual post objects/arrays
							foreach($posts as $post) {

								// We need to do this check here to convert post objects to arrays.
								if(is_object($post)){
									$post = get_object_vars($post);
								}

								// This swiper-slide contents are a direct copy of post/content.php and the
								// styles for it are in styles/layouts/_news.scss
								$id = $post['ID'];
								$defaultImage = \Blue2\Scruffy\Site::getDefaultImage($id);
								$newsCategories = get_the_terms($id, 'category');
								$newsThumbnailID = get_post_thumbnail_id($id);
								$newsDate = strtotime(get_the_date('', $id));
								$newsDate = date('F j, Y', $newsDate);
								$image = \Blue2\Scruffy\Site::acfImage($newsThumbnailID, 'news-archive', $id);
								$authors = get_field('authors', $id);
								$authorDescription = get_field('author_description', $id); ?>
                                <div class="swiper-slide">
                                    <article class="post-col">
                                        <div class="post-inner">
                                            <a href="<?php the_permalink($id); ?>">
                                                <div class="image-wrapper <?= $image['class']; ?>">
													<?= $image['output']; ?>
                                                    <div class="category-wrapper">
														<?php if($newsCategories) { ?>
                                                            <ul>
																<?php foreach($newsCategories as $news) {
																	// Take the value set in the CMS for this taxonomies colour, or use a default.
                                                                    if (get_field('category_colour', $news->taxonomy.'_'.$news->term_id)){
                                                                        $newsColour = " ".get_field('category_colour', $news->taxonomy.'_'.$news->term_id);
                                                                    } else {
                                                                        $newsColour = '#ABC7CA';
                                                                    } ?>
                                                                    <li style="background-color:<?= $newsColour ?>"><?= $news->name ?></li>
																<?php } ?>
                                                            </ul>
														<?php } ?>
                                                    </div>
                                                    <div class="button-wrapper">
                                                        <button>Read More</button>
                                                    </div>
                                                </div>
                                                <div class="content-wrapper">
                                                    <div class="news-info-holder">
														<?php if($newsCategories) { ?>
                                                            <ul>
																<?php foreach($newsCategories as $news) { ?>
                                                                    <li><?= $news->name; ?></li>
																<?php } ?>
                                                            </ul>
														<?php } ?>
                                                        <div class="date"><?= $newsDate; ?></div>
                                                    </div>
                                                    <h3><?= get_the_title($id); ?></h3>

                                                    <div class="author-info">
                                                        <div class="author-images">
															<?php if($authors) {
																$authorCount = 0;
																foreach($authors as $author) {
																	$image = \Blue2\Scruffy\Site::acfImage($author['author_image']['id'], 'author-image');
																	if ($authorCount++ == 2) break; ?>
                                                                    <div class="author-item <?= $image['class']; ?>">
																		<?= $image['output']; ?>
                                                                    </div>
																<?php }
															} else { ?>
                                                                <div class="author-item default-image">
																	<?= $defaultImage; ?>
                                                                </div>
															<?php } ?>
                                                        </div>
                                                        <div class="author-description">
															<?php if($authorDescription) {
																echo $authorDescription;
															} else {
																echo 'by Carnegie UK Trust';
															} ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        </div>
                                    </article>
                                </div>
							<?php } wp_reset_postdata(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
		<?php if($twitterLink && $showTwitter) { ?>
            <div class="row bottom-row">
                <div class="col-xl-5 col-xxl-4 bottom-col">
                    <a class="twitter-link" href="<?= $twitterLink ?>">View on Twitter</a>
                </div>
            </div>
		<?php } ?>
    </div>
</div>
