<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\TeamController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_theme_support('post-thumbnails');
        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return '...';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
       add_filter('walker_nav_menu_start_el', [$this, 'addChevronToMenuItemsWithChildren'], 10, 4 );
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('admin_menu', [$this, 'customAdminPages']);
        add_action('pre_get_posts', [$this, 'filterPosts']);
    }

    private function setupControllers(){
        new TeamController();
    }

    public function registerPostTypes()
    {
        Post\Team::registerPostType();
        Post\Programme::registerPostType();
    }

    public function addChevronToMenuItemsWithChildren( $item_output, $item, $depth, $args ) {
        if ( $args->theme_location == 'main_menu' && $args->menu_class == 'l-nav__menu') {
            if ( in_array( 'menu-item-has-children', $item->classes ) || in_array( 'page_item_has_children', $item->classes ) ) {
                $item_output = str_replace( $args->link_after . '</a>', $args->link_after . '<span class="fas fa-chevron-down main-menu-chevron"></span></a>', $item_output );
            }
        }
        return $item_output;
    }

    public function customAdminPages()
    {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page([
                'title' => 'News Settings',
                'parent' => 'edit.php',
                'capability' => 'edit_posts',
            ]);
            acf_add_options_page([
                'title' => 'Programme Settings',
                'parent' => 'edit.php?post_type=programme',
                'capability' => 'edit_posts',
            ]);
        }
    }

    public static function getDefaultImage($id = null) {
        if(has_term('podcasts', 'category', $id)) {
            $path = get_template_directory() . '/dist/images/podcast.svg';
        } else {
            $path = get_template_directory() . '/dist/images/icon.svg';
        }

        $file = file_get_contents($path);
        // remove xml header
        $file = str_replace(
            '<?xml version="1.0" encoding="UTF-8"?>',
            '',
            $file
        );
        // add class and attributes for accessibility
        return str_replace(
            '<svg',
            '<svg class="default-image" role="img" aria-label="DC Thomson"',
            $file
        );
    }

    public static function acfImage($id, $size, $postID = null) {
        if($id) {
            $imageAlt = get_post_meta($id, '_wp_attachment_image_alt', TRUE);
            $imageDetails = wp_get_attachment_image_src($id, $size);
            $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
            $imageClass = 'featured-image';
        } else {
            $image = self::getDefaultImage($postID);
            $imageClass = 'default-image';
        }
        return ['output' => $image, 'class' => $imageClass];
    }

    public static function getPostsYears($post_type = 'post') {
        global $wpdb;
        $result = [];
        $query_prepare = $wpdb->prepare("SELECT YEAR(post_date) FROM ($wpdb->posts) WHERE post_status = 'publish' AND post_type = %s GROUP BY YEAR(post_date) DESC", $post_type);
        $years = $wpdb->get_results($query_prepare);
        if ( is_array( $years ) && count( $years ) > 0 ) {
            foreach ( $years as $year ) {
                $result[] = json_decode(json_encode($year), true);
            }
        }
        sort($result);
        return $result;
    }

    public function filterPosts($query) {
        if ( !is_admin() && $query->is_main_query() && is_home()) {
            $metaQuery = ['relation' => 'AND'];
            if (isset($_GET['keyword']) && $_GET['keyword'] !== '') {
                $keyword = $_GET['keyword'];
                $query->set('s', $keyword);
            }
        }
    }

    public function customImageSizes()
    {
        add_image_size('author-image', 64, 64, true);
        add_image_size('news-archive', 492, 320, true);
        add_image_size('news-single', 1034, 0, false);

    }

}
