const people = () => {
    $('.team-col .cta a').on('click', function(e) {
        e.preventDefault();
        const teamOverlay = $('.team-overlay');
        const dataID = $(this).data('id');
        const emailData = $(this).data('email');
        const phoneData = $(this).data('phone');
        const twitterData = $(this).data('twitter');
        const descriptionData = $(this).data('description');
        const titleData = $(this).data('title');
        const positionData = $(this).data('position');
        const email = teamOverlay.find('.email');
        const phone = teamOverlay.find('.phone');
        const twitter = teamOverlay.find('.twitter-link');
        const description = teamOverlay.find('.description');
        const title = teamOverlay.find('.title');
        const position = teamOverlay.find('.position');

        teamOverlay.addClass('active');
        title.text(titleData);

        if (descriptionData) {
            description.show();
            description.text(descriptionData);
        } else {
            description.hide();
        }

        if (positionData) {
            position.show();
            position.text(positionData);
        } else {
            position.hide();
        }

        if (emailData) {
            $('.email-holder').show();
            email.text(emailData);
        } else {
            $('.email-holder').hide();
        }

        if (phoneData) {
            $('.phone-holder').show();
            phone.text(phoneData);
        } else {
            $('.phone-holder').hide();
        }

        if (twitterData) {
            twitter.show();
            twitter.attr('href', twitterData);
        } else {
            twitter.hide();
        }
    });

    $('.team-overlay .close').on('click', function() {
        $('.team-overlay').removeClass('active');
    });
};

export default people;
