<?php
namespace Blue2\Scruffy\Controllers;

class PublicationController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerTaxonomies']);
    }

    private function registerFilters()
    {
    }

    public function registerTaxonomies()
    {
        $type = new \Blue2\Common\Taxonomy("type", "Type", "Types", "publication", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
    }

    public static function getPublicationYears() {
        $publicationsArgs = [
            'post_type' => 'publication',
            'numberposts' => -1,
        ];
        $pubs = get_posts($publicationsArgs);
        $pubYears = [];

        foreach($pubs as $pub){

            $year = get_field('publication_year', $pub->ID);

            if($year !== null && $year !== '') {
                $pubYears[] = $year;
            }
        }
        return array_unique($pubYears);
    }

    public static function getPublications($term, $number = 10) {
        $args = [
            'post_type' => 'publication',
            'numberposts' => $number,
            'post_status' => 'publish',
            'tax_query' => [
                [
                    'taxonomy' => 'type',
                    'field' => 'slug',
                    'terms' => [$term],
                    'operator' => 'IN',
                ]
            ]
        ];
        if(isset($_GET['keyword'])) {
            $args['s'] = $_GET['keyword'];
        }
        if(isset($_GET['year']) && $_GET['year'] !== "") {
            $args['meta_query'][] = [
                'key' => 'publication_year',
                'value' => [$_GET['year']],
                'operator' => 'IN',
            ];
        }
        if(isset($_GET['theme' ]) && $_GET['theme'] !== "") {
            $args['tax_query']['relation'] = 'AND';
            $args['tax_query'][] = [
                'taxonomy' => 'theme',
                'field' => 'slug',
                'terms' => [$_GET['theme']],
                'operator' => 'IN',
            ];
        }
        $publications = get_posts($args);
        return $publications;
    }

}
