<?php
$id = !empty($args) ? $args['id'] : get_the_id();
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage($id);
$newsCategories = get_the_terms($id, 'category');
$newsThumbnailID = get_post_thumbnail_id($id);
$newsDate = strtotime(get_the_date('', $id));
$newsDate = date('F j, Y', $newsDate);
$image = \Blue2\Scruffy\Site::acfImage($newsThumbnailID, 'news-archive', $id);
$authors = get_field('authors', $id);
$authorDescription = get_field('author_description', $id); ?>

<article class="post-col col-md-6 col-xl-4">
    <div class="post-inner">
        <a href="<?php the_permalink($id); ?>">
            <div class="image-wrapper <?= $image['class']; ?>">
                <?= $image['output']; ?>
                <div class="category-wrapper">
	                <?php if($newsCategories) {
                        // Set a value in-case there is not one set in the CMS
                        $newsColour = '#ABC7CA'; ?>
                        <ul>
			                <?php foreach($newsCategories as $news) {
				                // Take the value set in the CMS for this taxonomies colour
                                $newsColour = " ".get_field('category_colour', $news->taxonomy.'_'.$news->term_id); ?>
                                <li style="background-color:<?= $newsColour ?>"><?= $news->name ?></li>
			                <?php } ?>
                        </ul>
	                <?php } ?>
                </div>
                <div class="button-wrapper">
                    <button>Read More</button>
                </div>
            </div>
            <div class="content-wrapper">
                <div class="news-info-holder">
                    <?php if($newsCategories) { ?>
                        <ul>
                            <?php foreach($newsCategories as $news) { ?>
                                <li><?= $news->name; ?></li>
                            <?php } ?>
                        </ul>
                    <?php } ?>
                    <div class="date"><?= $newsDate; ?></div>
                </div>
                <h3><?= get_the_title($id); ?></h3>

                <div class="author-info">
                    <div class="author-images">
                        <?php if($authors) {
                            $authorCount = 0;
                            foreach($authors as $author) {
                                $image = \Blue2\Scruffy\Site::acfImage($author['author_image']['id'], 'author-image');
                                if ($authorCount++ == 2) break; ?>
                                <div class="author-item <?= $image['class']; ?>">
                                    <?= $image['output']; ?>
                                </div>
                            <?php }
                        } else { ?>
                            <div class="author-item default-image">
                                <?= $defaultImage; ?>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="author-description">
                        <?php if($authorDescription) {
                            echo $authorDescription;
                        } else {
                            echo 'by Carnegie UK Trust';
                        } ?>
                    </div>
                </div>

            </div>
        </a>
    </div>
</article>
