(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["people"],{

/***/ "./assets/scripts/people.js":
/*!**********************************!*\
  !*** ./assets/scripts/people.js ***!
  \**********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($) {var people = function people() {
  var dataID;
  var emailData;
  var phoneData;
  var twitterData;
  var descriptionData;
  var titleData;
  var positionData;
  var teamOverlay;
  var email;
  var phone;
  var twitter;
  var description;
  var title;
  var position;
  var photoData;
  var photo;

  function getData(obj) {
    dataID = $(obj).data('id');
    emailData = $(obj).data('email');
    phoneData = $(obj).data('phone');
    twitterData = $(obj).data('twitter');
    descriptionData = $(obj).data('description');
    titleData = $(obj).data('title');
    positionData = $(obj).data('position');
    photoData = $(obj).data('photo');
    teamOverlay = $('.team-overlay');
    email = teamOverlay.find('.email');
    phone = teamOverlay.find('.phone');
    twitter = teamOverlay.find('.twitter-link');
    description = teamOverlay.find('.description');
    title = teamOverlay.find('.title');
    position = teamOverlay.find('.position');
    photo = teamOverlay.find('.photo');
  }

  function resetFields() {
    email.text('');
    phone.text('');
    twitter.text('');
    description.text('');
    title.text('');
    position.text('');
    photo.attr('src', '');
  }

  function setFields() {
    title.text(titleData);
    description.html(descriptionData);
    position.text(positionData);

    if (photoData) {
      var photoHolder = $('.photo-holder');
      photoHolder.show();
      photoHolder.find('img').attr('src', "".concat(photoData));
    } else {
      $('.photo-holder').hide();
    }

    if (emailData) {
      var emailHolder = $('.email-holder');
      emailHolder.show();
      email.text(emailData);
      emailHolder.find('a').attr('href', "mailto:".concat(emailData));
    } else {
      $('.email-holder').hide();
    }

    if (phoneData) {
      var phoneHolder = $('.phone-holder');
      phoneHolder.show();
      phone.text(phoneData);
      phoneHolder.find('a').attr('href', "tel:".concat(phoneData));
    } else {
      $('.phone-holder').hide();
    }

    if (twitterData) {
      twitter.show();
      twitter.attr('href', twitterData);
    } else {
      twitter.hide();
    }
  }

  function setPosition(obj) {
    $('.team-overlay').attr('data-position', obj.data('id'));
  }

  $('.right-control').on('click', function () {
    var currentPos = parseInt(teamOverlay.data('position'), 10);
    currentPos++;
    resetFields();

    if (currentPos > $('.team-item').length) {
      currentPos = 1;
    }

    $('.team-overlay').data('position', currentPos);
    getData($(".people-read-more[data-id=\"".concat(currentPos, "\"]")));
    setFields();
  });
  $('.left-control').on('click', function () {
    var currentPos = parseInt(teamOverlay.data('position'), 10);
    currentPos--;
    resetFields();

    if (currentPos <= 0) {
      currentPos = $('.team-item').length;
    }

    $('.team-overlay').data('position', currentPos);
    getData($(".people-read-more[data-id=\"".concat(currentPos, "\"]")));
    setFields();
  });
  $('.team-col a.people-read-more').on('click', function (e) {
    e.preventDefault();
    getData($(this));
    resetFields();
    setFields();
    setPosition($(this));
    teamOverlay.addClass('active');
  });
  $('.team-overlay .close').on('click', function () {
    teamOverlay.removeClass('active');
  });
};

/* harmony default export */ __webpack_exports__["default"] = (people);
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "jquery")))

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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