<?php
$colorArray = [
    "#004851",    
    "#ABC7CA",
    "#FF918F",
    "#8FE2B0",
    "#D9C756",
    "#4F9FA6",    
    "#007377",   
    "#FF6D6A",    
    "#88DBDF",
];
$colorIndex = 0;
$args = array(
    'post_parent'    => get_the_ID(), // use post_parent and not child_of
    'post_type'      => 'page',
    'posts_per_page' => -1,
    'meta_key'			=> 'chapter_number',
	'orderby'			=> 'meta_value',
	'order'				=> 'ASC'
);

$chapters = get_posts($args);
?>
<div class="pdf-banner">
    <img class="img-fluid" src="<?= get_field('banner_image')?>">
</div>
<div class="pdf-content-output">
    <div class="contain">
        <div class="row">
            <div class="col-12"><h1 class="text-center"><?= get_the_title(); ?></h1></div>
            <div class="col-12"><?= get_the_content(); ?></div>
            <?php
                if($chapters){ ?>
                <div class="col-12 mt-5 mb-3"></div>
                <?php
                    foreach($chapters as $chapter){
                        if($colorIndex == count($colorArray)){
                            $colorIndex = 0;
                        } ?>
                    <div class="col-6 pdf-chapter-block">
                        <a class="pdf-chapter" href="<?= get_the_permalink($chapter); ?>" style="background-color: <?= $colorArray[$colorIndex]; ?>;">
                            <h2 class="pdf-chapter-title"><?= get_the_title($chapter); ?></h2>
                            <?php \Blue2\Scruffy\Site::inlineSVG('/dist/images/icon-opacity.svg', 'programme-icon', 'The Carnegie UK Trust Logo'); ?>
                        </a>
                    </div>
                <?php
                        $colorIndex++;
                    }
                }
            ?>
        </div>
    </div>
</div>
<?php
    wp_reset_postdata();
?>
