(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["timeline"],{

/***/ "./assets/scripts/timeline.js":
/*!************************************!*\
  !*** ./assets/scripts/timeline.js ***!
  \************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* WEBPACK VAR INJECTION */(function($) {var timeline = function timeline() {
  var mobileBreakpoint = 767;

  function copyToClipboard(el, copiedNotice) {
    /* Get the text field */
    var copyText = document.getElementById(el);
    /* Select the text field */

    copyText.select(); //console.log(copyText.value);

    /* Copy the text inside the text field */

    document.execCommand('copy');
    /* Alert the copied text */

    copiedNotice.addClass('active').html("Copied <em>".concat(copyText.value, "</em>"));
    setTimeout(function () {
      copiedNotice.removeClass('active');
    }, 2000); // alert("Copied the text: " + copyText.value);
  }

  var setTimelineYearIndicator = function setTimelineYearIndicator() {
    var timelineCurYear = $('#timeline__modal .timeline__year').html();
  };

  function openSlide(modalContent, modalImg, openModal) {
    $('html').addClass('modal--opening');
    $('.timeline-modal-content').removeClass('in');
    setTimeout(function () {
      $('#timeline__modal .timeline__owl-carousel > .timeline-modal-content').html(modalContent.html());
      var theId = $('#timeline__modal .timeline-owl__linkshare input').attr('id');
      $('#timeline__modal .timeline-owl__linkshare input').attr('id', "".concat(theId, "__tlModal"));
      $('#timeline__modal > div .timeline__img-col .timeline-owl__social').before(modalImg);
      $('.timeline-modal-content').addClass('in');

      if (openModal === 1) {
        //todo - this was adjusted from toggleClass + showclass was added - MM 15/07/21
        $('.timeline__modal').addClass('timeline__modal--open');
        $('.timeline__modal').addClass('show');
        $('html').toggleClass('modal--open');
      }

      $('#timeline__modal .timeline-owl__linkshare').on('click', function () {
        var el = $('input', this).attr('id');
        var copiedNotice = $(this).find('.timeline-owl__linkshare-copied-ok');
        copyToClipboard(el, copiedNotice);
      });
      $('#timeline__modal .timeline-owl__social--link').on('click', function (e) {
        e.preventDefault();
        $(this).next('.timeline-owl__linkshare').toggleClass('timeline-owl__linkshare--active');
      }); // set src of modal img if required...

      var imgTag = $('#timeline__modal > div .timeline__img-col img');

      if (imgTag.attr('src') !== '') {
        imgTag.attr('src', imgTag.attr('data-src'));
      } // Update hash


      var updatedHash = $('#timeline__modal .timeline-modal-content > div').attr('data-hash');
      history.pushState(null, null, "#".concat(updatedHash));
      setTimelineYearIndicator();
    }, 100);
    setTimeout(function () {
      $('html').removeClass('modal--opening');
      $(window).trigger('resize');
    }, 600);
  }

  function checkLocationHash() {
    if (window.location.hash) {
      var hash = window.location.hash.substring(1); //Puts hash in variable, and removes the # character

      if ($(window).width() > mobileBreakpoint) {
        setTimeout(function () {
          $('html').addClass('modal--opening');
          var slideEl = $(".timeline__grid div[data-hash=\"".concat(hash, "\"]"));
          var modalContent = slideEl.parent();
          var modalImg = slideEl.parent().parent().find('img').clone();
          openSlide(modalContent, modalImg, 1);
        }, 200);
      } else {
        var target = $("#timeline_year-".concat(hash));
        setTimeout(function () {
          if (target.length) {
            //alert(target.offset().top);
            $('html, body').animate({
              scrollTop: target.offset().top - $('.banner--timeline').height()
            }, 1000);
            return false;
          }
        }, 500);
      } // hash found

    } else {// No hash found
    }
  }

  if ($('body').hasClass('page-template-template-timeline')) {
    var currentDecade = '#decade-0000';
    var prevDecade = currentDecade;
    var decadeTop = '#decade-1913';
    var slideTotal = $('#timeline__modal').attr('data-slide-total');
    var activeFilters = [];
    $(window).on('scroll', function () {
      if ($(window).scrollTop() > 100 && $(window).width() > 767) {
        $('body').addClass('reduced-header--timeline');
      } else {
        $('body').removeClass('reduced-header--timeline');
      } // monitor timeline decade anchors.


      $('a[id*="decade-"]').each(function () {
        decadeTop = $(this).offset().top - $(window).scrollTop();

        if (decadeTop < 80) {
          currentDecade = "#".concat($(this).attr('id'));
        }
      });

      if (prevDecade !== currentDecade) {
        prevDecade = currentDecade;
        $('.timeline_decade.active').removeClass('active');
        $('.timeline__next-prev-title ul>li.active').removeClass('active');
        $(".banner--timeline [href=\"".concat(currentDecade, "\"]")).addClass('active');
        $(".timeline__next-prev-title a[href=\"".concat(currentDecade, "\"]")).parent('li').addClass('active');
      }
    });
    console.log('build timeline controller');
    var timelineControllerHTML = '<ul class="timeline__nav">';
    var timelineNextPrevHTML = '<div class="timeline__next-prev"><div name="timeline__next-prev"><i class="timeline__prev timeline__arrow-left"></i><i class="timeline__next timeline__arrow-right"></i></div><div class="timeline__next-prev-title"><ul>';
    var timelineCatFilter = $('.timeline__cat-filter');
    var timelineTotalFilters;
    $('.timeline_decade').each(function () {
      timelineControllerHTML += "<li>".concat($(this)[0].outerHTML, "</li>");
      timelineNextPrevHTML += "<li>".concat($(this)[0].outerHTML, "</li>");
    });
    timelineControllerHTML += '</ul>';
    timelineNextPrevHTML += '</ul></div>';
    timelineControllerHTML = timelineControllerHTML.replace(/id="/gi, 'href="#');
    timelineControllerHTML = timelineControllerHTML.replace(/sr-only/g, 'timeline-controller__decade');
    timelineNextPrevHTML = timelineNextPrevHTML.replace(/id="/gi, 'href="#');
    timelineNextPrevHTML = timelineNextPrevHTML.replace(/name="/gi, 'id="');
    timelineNextPrevHTML = timelineNextPrevHTML.replace(/sr-only/g, 'timeline-controller__decade');
    $('header.banner .timeline__controller').append(timelineControllerHTML);
    timelineCatFilter.appendTo($('header.banner .timeline__controller')).removeClass('hidden'); //.append(timelineCatFilter);

    $('header.banner .timeline__controller').append(timelineNextPrevHTML);
    $('.timeline__next-prev-title ul>li').eq(0).addClass('active');
    $('.timeline__cat-filter>li').on('click', function () {
      var multipleFilters = 0;

      if (multipleFilters === 0) {
        $('.timeline__cat-filter>li').not(this).removeClass('timeline__cat-filter--active');
        $(this).toggleClass('timeline__cat-filter--active');
      } else {
        $(this).toggleClass('timeline__cat-filter--active');
      }

      var activeFilters = []; // Check and apply/remove filters from timeline grid.

      timelineTotalFilters = 0;
      $('.timeline__cat-filter>li').each(function () {
        timelineTotalFilters++;

        if ($(this).hasClass('timeline__cat-filter--active')) {
          activeFilters.push($(this).text());
        }
      });

      if (activeFilters.length > 0 && activeFilters.length < timelineTotalFilters) {
        $('.timeline__grid').attr('class', 'timeline__grid');
        $('.timeline__grid').addClass('timeline__grid--filtered animating');
        setTimeout(function () {
          $('.timeline__grid').removeClass('animating');
        }, 300);
        var arrayLength = activeFilters.length;

        for (var i = 0; i < arrayLength; i++) {
          $('.timeline__grid').addClass("timeline__grid-filter--".concat(activeFilters[i]));
        }
      } else {
        $('.timeline__grid').attr('class', 'timeline__grid');
      }
    }); // Allow grid item cat labels to work as filters.

    $('.timeline__grid .timeline__category').on('click', function () {
      var catToFilter = $(this).text().trim();
      $(".timeline__cat-filter .timeline__category--".concat(catToFilter)).trigger('click');
    });
    window.onhashchange = checkLocationHash;
    checkLocationHash();
    setTimelineYearIndicator(); // Trigger modal and go to slide.

    $('.timeline__grid-item>.timeline__link').on('click', function () {
      console.log('grid item clicked');

      if ($(window).width() > mobileBreakpoint) {
        //e.preventDefault();
        var slide = $(this).data('slide');
        var modalContent = $(this).parent().find('.modal-content');
        var modalImg = $(this).find('img').clone();
        openSlide(modalContent, modalImg, 1);
      }
    });
    $('.timeline__modal-close').on('click', function () {
      if ($(window).width() > mobileBreakpoint) {
        $('.timeline__modal--open').addClass('fade').removeClass('timeline__modal--open in');
        $('html').removeClass('modal--open');
        history.pushState('', document.title, window.location.pathname + window.location.search);
      }
    });
    $('.owl-nav .owl-prev').on('click', function (e) {
      e.preventDefault(); // get slide.

      var curSlide = $(this).parent().parent().find('.timeline-modal-content>div').attr('data-slide');
      curSlide--; // if a filter is on, check to find next visible slide.

      if ($('.timeline__grid').hasClass('timeline__grid--filtered')) {
        var isVisible = $(".timeline__grid .timeline__link[data-slide=\"".concat(curSlide, "\"]")).parent().css('opacity');

        do {
          if (isVisible < 1) {
            curSlide--;
          }

          if (curSlide < 0) {
            curSlide = slideTotal;
          }

          console.log(curSlide);
          isVisible = $(".timeline__grid .timeline__link[data-slide=\"".concat(curSlide, "\"]")).parent().css('opacity');
          console.log(isVisible);
        } while (isVisible < 1);
      }

      if (curSlide < 0) {
        curSlide = slideTotal;
      }

      $('.timeline-modal-content').removeClass('in'); //change slide.

      var newSlide = $(".timeline__grid .timeline__link[data-slide=\"".concat(curSlide, "\"]"));
      var modalContent = newSlide.parent().find('.modal-content'); // console.log(modalContent.html());

      var modalImg = newSlide.find('img').clone();
      openSlide(modalContent, modalImg, 0);
    });
    $('.owl-nav .owl-next').on('click', function (e) {
      e.preventDefault(); // get slide.

      var curSlide = $(this).parent().parent().find('.timeline-modal-content>div').attr('data-slide');
      curSlide++; // if a filter is on, check to find next visible slide.

      if ($('.timeline__grid').hasClass('timeline__grid--filtered')) {
        var isVisible = $(".timeline__grid .timeline__link[data-slide=\"".concat(curSlide, "\"]")).parent().css('opacity');

        do {
          if (isVisible < 1) {
            curSlide++;
          }

          if (curSlide > slideTotal) {
            curSlide = 0;
          }

          console.log(curSlide);
          isVisible = $(".timeline__grid .timeline__link[data-slide=\"".concat(curSlide, "\"]")).parent().css('opacity');
          console.log(isVisible);
        } while (isVisible < 1);
      }

      if (curSlide > slideTotal) {
        curSlide = 0;
      }

      $('.timeline-modal-content').removeClass('in'); //change slide.

      var newSlide = $(".timeline__grid .timeline__link[data-slide=\"".concat(curSlide, "\"]"));
      var modalContent = newSlide.parent().find('.modal-content');
      var modalImg = newSlide.find('img').clone();
      openSlide(modalContent, modalImg, 0);
    }); // Timeline navs

    $('.timeline_decade').on('click', function () {
      var elIndex = $(this).parent().index();
    });
    $('.timeline__prev').on('click', function () {
      var activeLi = $('.timeline__next-prev-title ul>li.active');

      if (activeLi.prev('li').length > 0) {
        activeLi.removeClass('active').prev('li').addClass('active');
        $('.timeline__next-prev-title ul>li.active a').trigger('click');
      }
    });
    $('.timeline__next').on('click', function () {
      var activeLi = $('.timeline__next-prev-title ul>li.active');

      if (activeLi.next('li').length > 0) {
        activeLi.removeClass('active').next('li').addClass('active');
        $('.timeline__next-prev-title ul>li.active a').trigger('click');
      }
    });
  }
};

/* harmony default export */ __webpack_exports__["default"] = (timeline);
/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! jquery */ "jquery")))

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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