import { fontawesome, throttle } from './utils';

const PdfAnchor = class {
    id = null;
    position = null;
    constructor(id, position) {
        this.id = id;
        this.position = position;
    }
};
const pdfChapterPosition = function(pdfAnchors) {
    const menuHeight = $('.l-header').height();
    const windowPosition = $(window).scrollTop() + $(window).height() - menuHeight;
    let anchorToHighlight = null;
    pdfAnchors.forEach(anchor => {
        if (anchorToHighlight === null && anchor.position + 250 <= windowPosition) {
            anchorToHighlight = anchor;
        }
    });

    if (anchorToHighlight !== null && typeof anchorToHighlight !== 'undefined') {
        $('.current-sub-chapter').removeClass('current-sub-chapter');
        $(`a[data-anchor='${anchorToHighlight.id}']`).addClass('current-sub-chapter');
    }
};

const nav = {
    breakpoint: 992,
    isOpen: false,
    lastWidth: window.innerWidth,
    el: {
        scrollEl:   document.documentElement,
        toggle:     document.querySelector('.l-nav__toggle'),
        nav:        document.querySelector('.l-nav'),
        header:     document.querySelector('.l-header'),
        submenus:   document.querySelectorAll('.l-nav__menu .sub-menu')
    },
    init: () => {
        nav.el.toggle.addEventListener('click', nav.toggle);
        window.addEventListener('resize', nav.resize);

        if (nav.el.submenus) {
            nav.el.submenus.forEach((el, i) => {
                const parent = el.parentElement;
                const link = parent.firstChild;

                parent.addEventListener('mouseover', () => nav.submenuOpen(parent, link, i));
                parent.addEventListener('mouseout', () => nav.submenuClose(parent, link, i));
            });
        }
    },

    toggle: () => {
        const isOpen = nav.el.toggle.getAttribute('data-state') === 'open';
        if (isOpen) {
            nav.close();
        } else {
            nav.open();
        }
    },

    open: () => {
        nav.el.scrollEl.style.overflow = 'hidden';

        nav.el.header.setAttribute('data-state', 'open');

        nav.el.nav.setAttribute('data-state', 'open');

        nav.el.toggle.setAttribute('data-state', 'open');
        nav.el.toggle.setAttribute('aria-expanded', 'true');
        nav.el.toggle.setAttribute('aria-label', 'Close primary navigation');

        nav.el.nav.focus();

        nav.isOpen = true;
    },

    close: () => {
        nav.el.scrollEl.style.overflow = null;

        nav.el.header.setAttribute('data-state', 'closed');

        nav.el.nav.setAttribute('data-state', 'closed');

        nav.el.toggle.setAttribute('data-state', 'closed');
        nav.el.toggle.setAttribute('aria-expanded', 'false');
        nav.el.toggle.setAttribute('aria-label', 'Open primary navigation');

        nav.el.toggle.focus();

        nav.isOpen = false;
    },

    resize: throttle(() => {
        const currentWidth = window.innerWidth;

        // going from below breakpoint to above
        if (nav.lastWidth <= nav.breakpoint && currentWidth > nav.breakpoint) {
            // if nav open, close it
            if (nav.isOpen) {
                nav.close();
            }

            // add submenu aria
            nav.submenuAria(true);
        }

        // going from above breakpoint to below
        if (nav.lastWidth > nav.breakpoint && currentWidth <= nav.breakpoint) {
            // remove submenu aria
            nav.submenuAria(false);
        }

        nav.lastWidth = currentWidth;
    }, 1000)
};

const common = () => {
    if (!$('body').hasClass('page-template-template-timeline')) {
        nav.init();
    }
    fontawesome();

    $('.scroll-to-top').each(function() {
        $(this).click(function() {
            $('html,body').animate({ scrollTop: 0 }, 'slow');
            return false;
        });
    });

    $(window).scroll(function() {
        const scrollButton = $('.scroll-to-top');
        if ($(this).scrollTop() > 200) {
            scrollButton.addClass('active');
        }
        if ($(this).scrollTop() < 200) {
            scrollButton.removeClass('active');
        }
    });

    const pdfAnchors = [];

    $(document).on('ready resize', function() {
        if ($('.pdf-anchor').length > 0) {
            const menuHeight = $('.l-header').height();
            $('html, body').css('scroll-behavior', 'smooth');
            $('.pdf-anchor').each(function() {
                const pdfAnchorElement = $(this);
                const pdfAnchor = new PdfAnchor($(pdfAnchorElement).attr('id'), $(pdfAnchorElement).offset().top);
                $(pdfAnchorElement).css('bottom', `${menuHeight}px`);
                pdfAnchors.push(pdfAnchor);
            });
            pdfAnchors.reverse();
        }
        pdfChapterPosition(pdfAnchors);
    });

    let scrollTimeout = null;
    $(window).on('scroll', () => {
        clearTimeout(scrollTimeout);
        scrollTimeout = setTimeout(() => pdfChapterPosition(pdfAnchors), 10);
    });
};

export default common;
