<?php
    $subChaptersAncorLinks = [];
?>
<div class="pdf-content-output">
    <div class="contain">
        <div class="row">
            <div class="col-12">
                <a href="<?= get_permalink( $post->post_parent ); ?>" class="btn btn-primary pdf-back-button"><i class="fa-solid fa-chevron-left"></i>&nbsp;Back to main page</a>
                <h1 class="text-center"><?= get_the_title(); ?></h1>
            </div>
            <div class="col-12 mb-5"><?= get_the_content(); ?></div>
            <div class="col-12 col-lg-7 px-0">
                <?php
                    if(have_rows('subchapters')){ ?>

                    <?php
                        while(have_rows('subchapters')){
                        the_row();
                        $subchapterTitle = get_sub_field('title');
                        $subchapterContent = get_sub_field('content');
                        $subchapterNumber = get_sub_field('subchapter_number');
                        $subchapterAnchorLink = get_sub_field('ancor_link');
                        if($subchapterAnchorLink && !empty($subchapterAnchorLink)){
                            $subChaptersAncorLinks[$subchapterNumber." ".$subchapterTitle] = $subchapterAnchorLink;
                        }
                        ?>
                        <div class="pdf-anchor" name="<?= $subchapterAnchorLink?>" id="<?= $subchapterAnchorLink?>"></div>
                        <div class="col-12 mb-5">
                            <h2 class="pdf-chapter-title"><?= $subchapterNumber ? $subchapterNumber . " - " : ""; ?><?= $subchapterTitle; ?></h2>
                            <div class="pdf-content">
                                <?= $subchapterContent; ?>
                            </div>
                        </div>
                    <?php
                        }
                    }
                ?>
            </div>
            <div class="d-none d-lg-block col-lg-5">
                <?php
                    if(!empty($subChaptersAncorLinks)){ ?>
                        <div class="row sticky-menu">
                            <div class="col-12">
                                <div class="chapter-title"><?= get_the_title(); ?></div>
                            </div>
                            <?php
                                foreach($subChaptersAncorLinks as $sectionTitle => $ancorLink){ ?>
                                    <div class="col-12">
                                        <a data-anchor="<?= $ancorLink;?>" href="#<?= $ancorLink;?>"><h3 class="sub-chapter-link"><?= $sectionTitle; ?></h3></a>
                                    </div>
                               <?php }
                            ?>
                        </div>
                    <?php }
                ?>
            </div>
        </div>
    </div>
</div>

