const people = () => {
    let dataID;
    let emailData;
    let phoneData;
    let twitterData;
    let descriptionData;
    let titleData;
    let positionData;
    let teamOverlay;
    let email;
    let phone;
    let twitter;
    let description;
    let title;
    let position;
    let photoData;
    let photo;

    function getData(obj) {
        dataID = $(obj).data('id');
        emailData = $(obj).data('email');
        phoneData = $(obj).data('phone');
        twitterData = $(obj).data('twitter');
        descriptionData = $(obj).data('description');
        titleData = $(obj).data('title');
        positionData = $(obj).data('position');
        photoData = $(obj).data('photo');

        teamOverlay = $('.team-overlay');
        email = teamOverlay.find('.email');
        phone = teamOverlay.find('.phone');
        twitter = teamOverlay.find('.twitter-link');
        description = teamOverlay.find('.description');
        title = teamOverlay.find('.title');
        position = teamOverlay.find('.position');
        photo = teamOverlay.find('.photo');
    }

    function resetFields() {
        email.text('');
        phone.text('');
        twitter.text('');
        description.text('');
        title.text('');
        position.text('');
        photo.attr('src','');
    }

    function setFields() {
        title.text(titleData);
        description.text(descriptionData);
        position.text(positionData);

        if (photoData) {
            const photoHolder = $('.photo-holder');
            photoHolder.show();
            photoHolder.find('img').attr('src', `${photoData}`);
        } else {
            $('.photo-holder').hide();
        }

        if (emailData) {
            const emailHolder = $('.email-holder');
            emailHolder.show();
            email.text(emailData);
            emailHolder.find('a').attr('href', `mailto:${emailData}`);
        } else {
            $('.email-holder').hide();
        }

        if (phoneData) {
            const phoneHolder = $('.phone-holder');
            phoneHolder.show();
            phone.text(phoneData);
            phoneHolder.find('a').attr('href', `tel:${phoneData}`);
        } else {
            $('.phone-holder').hide();
        }

        if (twitterData) {
            twitter.show();
            twitter.attr('href', twitterData);
        } else {
            twitter.hide();
        }
    }

    function setPosition(obj) {
        $('.team-overlay').attr('data-position', obj.data('id'));
    }

    $('.right-control').on('click', function() {
        let currentPos = parseInt(teamOverlay.data('position'), 10);
        currentPos++;
        resetFields();
        if (currentPos > $('.people-read-more').length) {
            currentPos = 1;
        }
        $('.team-overlay').data('position', currentPos);
        getData($(`.people-read-more[data-id="${currentPos}"]`));
        setFields();
    });

    $('.left-control').on('click', function() {
        let currentPos = parseInt(teamOverlay.data('position'), 10);
        currentPos--;
        resetFields();
        if (currentPos <= 0) {
            currentPos = $('.people-read-more').length;
        }
        $('.team-overlay').data('position', currentPos);
        getData($(`.people-read-more[data-id="${currentPos}"]`));
        setFields();
    });

    $('.team-col a.people-read-more').on('click', function(e) {
        e.preventDefault();
        getData($(this));
        resetFields();
        setFields();
        setPosition($(this));
        teamOverlay.addClass('active');
    });

    $('.team-overlay .close').on('click', function() {
        teamOverlay.removeClass('active');
    });
};

export default people;
