<?php
$address = get_field('address_ouput', 'option');
$charity = get_field('charity_text', 'option');
$phone = get_field('contact_phone_number', 'option');
$email = get_field('contact_email_address', 'option');
$socials = get_field('social_media_channels', 'option');
$logos = get_field('company_logos', 'option');
$footerNewsletter = get_field('footer_newsletter', 'option');
?>

<footer class="site-footer">
    <div class="contain">

        <div class="custom-grid">
            <div class="div1">
                <?php
                $path = get_template_directory() . '/dist/images/icon.svg';
                $file = file_get_contents($path);

                // remove xml header
                $file = str_replace(
                    '<?xml version="1.0" encoding="UTF-8"?>',
                    '',
                    $file
                );

                // add class and attributes for accessibility
                echo str_replace(
                    '<svg',
                    '<svg class="footer-icon" role="img" aria-label="The Carnegie UK Trust Logo"',
                    $file
                );
                ?>
            </div>
            <div class="div2">
                <h3>Contact</h3>
                <?php if($address) { ?>
                    <div class="address-output"><?= $address; ?></div>
                <?php } ?>
            </div>
            <div class="div3">
                <h3>Connect</h3>
                <?php if($socials) {

                    ?>
                    <ul>
                        <?php foreach($socials as $social) {?>
                            <li><a href="<?= $social['full_url']; ?>" target="_blank"><span class="fab <?= $social['platform']; ?>" id="theme-svg"></span> <?= $social['platform_text']; ?></a></li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
            <div class="div4">
                <h3>Legal</h3>
                <?php
                if (has_nav_menu( 'footer_menu' )) {
                    wp_nav_menu(['theme_location' => 'footer_menu', 'menu_class' => '']);
                }
                ?>
            </div>
            <div class="div5">
                <div class="contact-items">
                    <?php if($phone) { ?><div class="contact-item"><span class="fas fa-phone"></span> <a href="tel:<?= $phone; ?>"><?= $phone; ?></a></div><?php } ?>
                    <?php if($email) { ?><div class="contact-item"><span class="fas fa-envelope"></span><a href="email:<?= $email; ?>"><?= $email; ?></a></div><?php } ?>
                </div>
            </div>
            <div class="div6">
                <h3>Sign up to our bi-monthly newsletter</h3>
                <?php if($footerNewsletter) { ?>
                    <div class="footer-newsletter">
                        <?= do_shortcode($footerNewsletter); ?>
                    </div>
                <?php } ?>
            </div>
        </div>

        <?php if($logos) { ?>
            <div class="company-logos">
                <?php foreach($logos as $logo) { ?>
                    <div class="logo-item">
                        <?php if($logo['link']) { ?><a href="<?= $logo['link']['url']; ?>" target="<?= $logo['link']['target']; ?>"><?php } ?>
                            <img src="<?= $logo['logo']['url']; ?>" alt="<?= $logo['text']; ?>" title="<?= $logo['text']; ?>">
                        <?php if($logo['link']) { ?></a>     <?php } ?>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>

        <div class="row">
            <div class="col-lg-4">
                <p class="copyright">&copy; <?= date("Y") . ' ' . get_field('company_name', 'option'); ?></p>
            </div>
            <div class="col-lg-8 text-right">
                <p class="charity"><?= $charity; ?></p>
            </div>
        </div>

        <div class="row">
            <div class="credit col-12">
                <p>Website by <?= do_shortcode( '[blue2_logo type="light"]' ); ?></p>
            </div>
        </div>

    </div>
</footer>
