<?php
$title = get_sub_field('title');
$description = get_sub_field('description');
$cta = get_sub_field('cta');
$list = get_sub_field('list_items');

if($list) { ?>
    <div class="custom-flexible-section coloured-title-list">
        <div class="contain">
            <div class="top-title">
                <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
                <?php if($description) { ?><div class="description"><?= $description; ?></div><?php } ?>
            </div>

            <div class="section-holder">
                <div class="offset-grid">
                    <div class="list-grid">
                        <?php foreach($list as $item) { ?>
                            <div class="list-item">
                                <h3 class="<?= 'color-' . $item['colour']; ?>"><?= $item['title']; ?></h3>
                                <div class="description"><?= $item['description']; ?></div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>

            <?php if($cta) { ?>
                <div class="cta-offset">
                    <div class="cta fw-700 u-case text-center"><a href="<?= $cta['url']; ?>"><?= $cta['title']; ?></a></div>
                </div>
            <?php } ?>
        </div>
    </div>
<?php } ?>
