<?php
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage(get_the_id());
$altTitle = get_field('alternative_programme_title');
$relatedPeople = get_field('related_people');
$relatedDownloads = get_field('related_downloads');
$relatedNews = get_field('related_news');
$relatedBlogs = get_field('related_blogs');
$furtherMaterials = get_field('further_materials');
$hideReadMore = get_field('disable_team_read_more_globally', 'option');
?>

<main class="custom-programme-single">
    <div class="programme-header">
        <div class="contain programme-header__contain">
            <div class="primary-wrapper">
                <div class="news-info-holder">
                    <?php
                    if ( function_exists('yoast_breadcrumb') ) {
                        yoast_breadcrumb( '<div class="custom-breadcrumbs">','</div>' );
                    }
                    ?>
                </div>
                <h1><?= $altTitle ?: get_the_title(); ?></h1>
            </div>
        </div>
    </div>
    <section class="programme-output">
        <div class="contain">
            <div class="row">
                <div class="offset-lg-2 col-lg-8">
                    <div class="content-wrapper">
                        <?php the_content(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php if($relatedPeople) { ?>
        <section class="speak-to-us">
            <?php \Blue2\Scruffy\Site::inlineSVG('/dist/images/lines/line5.svg', 'top-line', '', true); ?>
            <div class="contain">
                <h2 class="speak-title">Speak to us</h2>
                <div class="row d-flex justify-content-center">
                    <?php foreach($relatedPeople as $post) {
                        setup_postdata($post);
                        get_template_part('templates/team/content');
                    } wp_reset_postdata(); ?>
                </div>
            </div>
            <?php
            if(!$hideReadMore) {
                get_template_part('templates/sections/team-overlay');
            } ?>
            <?php \Blue2\Scruffy\Site::inlineSVG('/dist/images/lines/line6.svg', 'bottom-line', '', true); ?>
        </section>
    <?php } ?>

    <section class="related-output">
        <?php if($relatedDownloads) { ?>
            <div class="downloads related-block">
                <div class="contain">
                    <div class="top-holder">
                        <h2>Downloads</h2>
                        <div class="navigation active">
                            <div class="download-prev">
                            <span class="fa-stack">
                                <span class="fas fa-circle fa-stack-2x"></span>
                                <span class="fas fa-chevron-left fa-stack-1x custom-chevron"></span>
                            </span>
                            </div>
                            <div class="download-next">
                            <span class="fa-stack">
                                <span class="fas fa-circle fa-stack-2x"></span>
                                <span class="fas fa-chevron-right fa-stack-1x custom-chevron"></span>
                            </span>
                            </div>
                        </div>
                    </div>

                    <div class="related-view active">
                        <div class="carousel-view">
                            <div class="grid-1">
                                <div class="view-all-col u-case fw-700">
                                    <span>View All</span>
                                </div>
                            </div>
                            <div class="grid-2">
                                <div class="swiper-container related-swiper download-swiper">
                                    <div class="swiper-wrapper">
                                        <?php foreach($relatedDownloads as $download) { ?>
                                            <div class="swiper-slide">
                                                <div class="related-item">
                                                    <a href="<?= $download['file']['url']; ?>" target="_blank">
                                                        <div class="read-more fw-700 u-case"><span>Read More</span></div>
                                                        <div class="date"><?= $download['date']; ?></div>
                                                        <h3><?= $download['name']; ?></h3>
                                                    </a>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="related-view inactive">
                        <div class="grid-view">
                            <div class="grid-item">
                                <div class="view-all-col u-case fw-700">
                                    <span>View Less</span>
                                </div>
                            </div>
                            <?php foreach($relatedDownloads as $download) {?>
                                <div class="grid-item">
                                    <div class="related-item">
                                        <a href="<?= $download['file']['url']; ?>" target="_blank">
                                            <div class="read-more fw-700 u-case"><span>Read More</span></div>
                                            <div class="date"><?= $download['date']; ?></div>
                                            <h3><?= $download['name']; ?></h3>
                                        </a>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                    <hr/>
                </div>
            </div>
        <?php } ?>
        <?php if($relatedBlogs) {
            get_template_part('templates/sections/related-section', null, [
                'name_single' => 'blog',
                'name_plural' => 'blogs',
                'data' => $relatedBlogs
            ]);
        } ?>
        <?php if($relatedNews) {
            get_template_part('templates/sections/related-section', null, [
                'name_single' => 'news',
                'name_plural' => 'news',
                'data' => $relatedNews
            ]);
        }?>
    </section>

    <?php if($furtherMaterials) {
        $furtherMaterialsText = get_field('further_materials_content'); ?>
        <section class="further-materials">
            <div class="contain">
                <div class="row">
                    <div class="offset-lg-2 col-lg-8">
                        <h2>Further Materials</h2>
                        <?php if($furtherMaterialsText) { ?><div class="desc"><?= $furtherMaterialsText; ?></div><?php } ?>
                        <div class="materials">
                            <ol>
                                <?php foreach($furtherMaterials as $material) { ?>
                                    <li><?= $material['text']; ?></li>
                                <?php } ?>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php } ?>
</main>
