<?php
$queryObject = get_queried_object();
global $teamCounter;
$teamCounter = 1;
$hideReadMore = get_field('disable_team_read_more_globally', 'option');
?>
<div class="custom-team-archive">
    <?php get_template_part('templates/sections/title-bar', null, [
        'title' => $queryObject->name,
        'description' => $queryObject->description
    ]); ?>
    <div class="archive-output">
        <div class="contain">
            <div class="row row-eq-height">
                <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
            </div>
            <div class="custom-pagination">
                <?php
                the_posts_pagination([
                    'mid_size' => 1,
                    'prev_text' => __('Previous', 'textdomain'),
                    'next_text' => __('Next', 'textdomain'),
                    'before_page_number' => '<span class="meta-nav screen-reader-text">' . __('', '') . ' </span>',
                ]); ?>
            </div>
        </div>
    </div>
</div>
<?php if(!$hideReadMore) {
    get_template_part('templates/sections/team-overlay');
} ?>

