<?php
$title = get_sub_field('title');
$description = get_sub_field('description');
$image = get_sub_field('image');
?>
<section class="custom-flexible-section standard-content-section">
    <div class="contain">
        <div class="custom-grid">
            <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
            <?php if($description) { ?><div class="desc"><?= $description; ?></div><?php } ?>
        </div>
    </div>
    <?php if($image) {
        $imageStyle = get_sub_field('image_style');
        switch($imageStyle){
            case 'full-width':
                $class = 'full-width';
                break;
            case 'contained':
                $class = 'contain contained-width';
                break;
            case 'contained-centred':
                $class = 'contain contained-centred';
                break;
        }
        ?>
        <div class="image-container <?= $class; ?>">
            <img src="<?= $image['url']; ?>" alt="<?= $image['alt']; ?>" class="standard-image">
        </div>
    <?php } ?>
</section>
