<?php
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage();
$newsCategories = get_the_terms(get_the_id(), 'category');
$newsThumbnailID = get_post_thumbnail_id();
$newsDate = strtotime(get_the_date());
$newsDate = date('F j, Y', $newsDate);

$author = get_the_author_meta('nickname',get_the_id());

if($newsThumbnailID) {
    $imageAlt = get_post_meta($newsThumbnailID, '_wp_attachment_image_alt', TRUE);
    $imageDetails = wp_get_attachment_image_src($newsThumbnailID, 'news-carousel');
    $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
    $imageClass = 'featured-image';
} else {
    $image = $defaultImage;
    $imageClass = 'default-image';
}
?>

<div class="post-col col-lg-4">
    <div class="post-inner">
        <div class="image-wrapper <?= $imageClass; ?>">
            <?= $image; ?>
        </div>
        <div class="content-wrapper">
            <div class="holder">
                <?php if($newsCategories) { ?>
                    <ul>
                        <?php foreach($newsCategories as $news) { ?>
                            <li><a href="<?= get_category_link($news->term_id); ?>"><?= $news->name; ?></a></li>
                        <?php } ?>
                    </ul>
                <?php } ?>
                <div class="date"><?= $newsDate; ?></div>
            </div>
            <h3><?= the_title(); ?></h3>
        </div>
    </div>
</div>


