<?php
$uncategorisedCategory = get_term_by('slug', 'uncategorised', 'category');
$newsCategories = get_categories(['hide_empty' => false, 'exclude' => $uncategorisedCategory->term_id]);
$queryObject = get_queried_object();
?>

<div class="custom-post-archive">
    <?php get_template_part('templates/sections/title-bar', null, [
        'title' => get_the_title(get_option('page_for_posts', true)),
        'description' => get_field('news_archive_description', 'option')
    ]); ?>

    <div class="contain">
        <div class="filter-output">
            <h2>Filter results:</h2>
            <ul class="filter-categories">
                <li class="<?= is_home() ? 'active-filter' : ""; ?> fw-700"><a href="<?= get_the_permalink(get_option('page_for_posts', true)) ?>">All</a></li>
                <?php if($newsCategories) {
                    foreach($newsCategories as $news) { ?>
                        <li class="<?= $queryObject->slug == $news->slug ? 'active-filter' : ""; ?> fw-700"><a href="<?= get_category_link($news->term_id); ?>"><?= $news->name; ?></a></li>
                    <?php } ?>
                <?php } ?>
            </ul>
        </div>
    </div>

    <div class="archive-output">
        <div class="contain">
            <div class="row row-eq-height">
                <?php Blue2\Scruffy\Utils::archiveLoop(); ?>
            </div>

        </div>
    </div>
</div>



