<?php
$colouredBlocks = get_sub_field('coloured_blocks');
$title = get_sub_field('coloured_section_title');
$subtitle = get_sub_field('coloured_section_subtitle');

$primaryTitle = get_sub_field('primary_title');
$primaryDesc = get_sub_field('primary_description');

$secondaryTitle = get_sub_field('secondary_title');
$secondaryDesc = get_sub_field('secondary_description');
?>

<section class="custom-flexible-section coloured-block-info-section">
    <div class="info-sections">
        <div class="contain">
            <div class="custom-grid">
                <?php if($primaryTitle) { ?><h2><?= $primaryTitle; ?></h2><?php } ?>
                <?php if($primaryDesc) { ?><div class="desc"><?= $primaryDesc; ?></div><?php } ?>
            </div>
        </div>
    </div>

    <div class="contain">
        <div class="title-section">
            <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
            <?php if($subtitle) { ?><div class="sub-text"><?= $subtitle; ?></div><?php } ?>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row no-gutters">
            <?php foreach($colouredBlocks as $block) { ?>
                <div class="col-md-6 col-xl-3 block-col <?= 'color-' . $block['colour']; ?>">
                    <div class="block-inner">
                        <h3><?= $block['title']; ?></h3>
                        <div class="desc"><?= $block['description']; ?></div>
                        <?php if($block['cta']) { ?>
                            <div class="cta fw-700 u-case"><a href="<?= $block['cta']['url']; ?>"><?= $block['cta']['title']; ?></a></div>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>

    <div class="info-sections">
        <div class="contain">
            <div class="custom-grid">
                <?php if($secondaryTitle) { ?><h2><?= $secondaryTitle; ?></h2><?php } ?>
                <?php if($secondaryDesc) { ?><div class="desc"><?= $secondaryDesc; ?></div><?php } ?>
            </div>
        </div>
    </div>

</section>
