import { fontawesome, throttle } from './utils';
import Swiper from 'swiper';

const nav = {
    breakpoint: 992,
    isOpen: false,
    lastWidth: window.innerWidth,
    el: {
        scrollEl:   document.documentElement,
        toggle:     document.querySelector('.l-nav__toggle'),
        nav:        document.querySelector('.l-nav'),
        header:     document.querySelector('.l-header'),
        submenus:   document.querySelectorAll('.l-nav__menu .sub-menu')
    },
    init: () => {
        nav.el.toggle.addEventListener('click', nav.toggle);
        window.addEventListener('resize', nav.resize);

        if (nav.el.submenus) {
            nav.el.submenus.forEach((el, i) => {
                const parent = el.parentElement;
                const link = parent.firstChild;

                parent.addEventListener('mouseover', () => nav.submenuOpen(parent, link, i));
                parent.addEventListener('mouseout', () => nav.submenuClose(parent, link, i));
            });
        }
    },

    toggle: () => {
        const isOpen = nav.el.toggle.getAttribute('data-state') === 'open';
        if (isOpen) {
            nav.close();
        } else {
            nav.open();
        }
    },

    open: () => {
        nav.el.scrollEl.style.overflow = 'hidden';

        nav.el.header.setAttribute('data-state', 'open');

        nav.el.nav.setAttribute('data-state', 'open');

        nav.el.toggle.setAttribute('data-state', 'open');
        nav.el.toggle.setAttribute('aria-expanded', 'true');
        nav.el.toggle.setAttribute('aria-label', 'Close primary navigation');

        nav.el.nav.focus();

        nav.isOpen = true;
    },

    close: () => {
        nav.el.scrollEl.style.overflow = null;

        nav.el.header.setAttribute('data-state', 'closed');

        nav.el.nav.setAttribute('data-state', 'closed');

        nav.el.toggle.setAttribute('data-state', 'closed');
        nav.el.toggle.setAttribute('aria-expanded', 'false');
        nav.el.toggle.setAttribute('aria-label', 'Open primary navigation');

        nav.el.toggle.focus();

        nav.isOpen = false;
    },

    resize: throttle(() => {
        const currentWidth = window.innerWidth;

        // going from below breakpoint to above
        if (nav.lastWidth <= nav.breakpoint && currentWidth > nav.breakpoint) {
            // if nav open, close it
            if (nav.isOpen) {
                nav.close();
            }

            // add submenu aria
            nav.submenuAria(true);
        }

        // going from above breakpoint to below
        if (nav.lastWidth > nav.breakpoint && currentWidth <= nav.breakpoint) {
            // remove submenu aria
            nav.submenuAria(false);
        }

        nav.lastWidth = currentWidth;
    }, 1000)
};

const common = () => {
    nav.init();
    fontawesome();
};

export default common;
