<?php
namespace Blue2\Scruffy\Controllers;

class TeamController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerActions()
    {
        add_action('init', [$this, 'registerTaxonomies']);
        add_action('pre_get_posts', [$this, 'orderTeam']);
    }

    private function registerFilters()
    {
    }

    public function registerTaxonomies()
    {
        $personType = new \Blue2\Common\Taxonomy("people", "Type", "Types", "team", [], $args = [
            'show_ui' => true,
            'query_var' => true,
            'show_admin_column' => true,
        ]);
    }

    public function orderTeam($query) {
        if ( !is_admin() && $query->is_main_query() && (is_post_type_archive('people') || is_tax('people'))) {
            $query->set('orderby', 'title');
            $query->set('order', 'ASC');
        }
    }
}
