<?php if(is_page_template('template-timeline.php')) { ?>
    <header class="banner banner--timeline">
        <div class="container-fluid upperheader">
            <div class="row">
                <div class="col-xs-8 col-sm-3 col-md-2">
                    <a class="brand" href="<?= esc_url(home_url('/')); ?>">
                        <?php \Blue2\Scruffy\Site::inlineSVG('/dist/images/logo.svg', 'timeline-logo', 'The Carnegie UK Trust'); ?>
                    </a>
                </div>
                <div class="timeline__controller col-xs-4 col-sm-9 col-md-10">
                </div>
            </div>
        </div>
    </header>
<?php } else { ?>
    <header class="l-header" data-state="closed">
        <div class="l-header__contain contain">
            <a class="l-header__brand" href="<?= esc_url(home_url('/')); ?>">
                <?php \Blue2\Scruffy\Site::inlineSVG('/dist/images/logo.svg', 'l-header__logo', 'The Carnegie UK Trust'); ?>
            </a>
            <nav class="l-header__nav l-nav">
                <button
                        id="nav-toggle"
                        type="button"
                        class="l-nav__toggle b-navToggle"
                        data-state="closed"
                        aria-controls="primary-nav"
                        aria-expanded="false"
                        aria-label="Open primary navigation">
                    <div class="b-navToggle__burger">
                        <span class="b-navToggle__bar"></span>
                        <span class="b-navToggle__bar"></span>
                        <span class="b-navToggle__bar"></span>
                    </div>
                </button>

                <div class="l-nav__wrap" id="primary-nav" data-state="closed">
                    <?php if (has_nav_menu('main_menu')) {
                        wp_nav_menu([
                            'theme_location'    => 'main_menu',
                            'menu_container'    => 'ul',
                            'menu_class'        => 'l-nav__menu',
                            'items_wrap'        => '<ul id="%1$s" class="%2$s" role="list">%3$s</ul>',
                        ]);
                    } ?>
                </div>
            </nav>
        </div>
    </header>
    <div class="scroll-to-top">
    <span class="fa-stack">
        <span class="fas fa-circle fa-stack-2x"></span>
        <span class="fas fa-arrow-alt-up fa-stack-1x custom-arrow"></span>
    </span>
    </div>
<?php } ?>
