<?php
$title = get_sub_field('title');
$description = get_sub_field('description');
$secondaryDescription = get_sub_field('secondary_description');
$cta = get_sub_field('cta');
$list = get_sub_field('list_items');

if(is_front_page()){
    global $count;
    $count++;
}

$colouredTitleClass = is_front_page() && isset($count) && $count == 1 ? 'primary-coloured-list' : 'secondary-coloured-list';

if($list) { ?>
    <div class="custom-flexible-section coloured-title-list <?= $colouredTitleClass; ?>">

        <?php if(is_front_page() && isset($count) && $count == 1){
            \Blue2\Scruffy\Site::inlineSVG('/dist/images/lines/line2.svg', 'large-line', '', true);
        } else {
            \Blue2\Scruffy\Site::inlineSVG('/dist/images/lines/line3.svg', 'top-line', '', true);
            \Blue2\Scruffy\Site::inlineSVG('/dist/images/lines/line4.svg', 'bottom-line', '', true);
        } ?>

        <div class="contain">
            <div class="top-title">
                <?php if($title) { ?><h2><?= $title; ?></h2><?php } ?>
                <?php if($description) { ?><div class="description"><?= $description; ?></div><?php } ?>
            </div>

            <div class="section-holder">
                <div class="offset-grid">
                    <div class="list-grid">
                        <?php foreach($list as $item) { ?>
                            <div class="list-item">
                                <h3 class="<?= 'color-' . $item['colour']; ?>"><?= $item['title']; ?></h3>
                                <div class="description"><?= $item['description']; ?></div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>

            <?php if($cta) { ?>
                <div class="cta-offset">
                    <div class="cta fw-700 u-case text-center"><a href="<?= $cta['url']; ?>"><?= $cta['title']; ?></a></div>
                </div>
            <?php } ?>

            <?php if($secondaryDescription) { ?>
                <div class="bottom-holder">
                    <div class="description"><?= $secondaryDescription; ?></div>
                </div>
            <?php } ?>

        </div>
    </div>
<?php } ?>
