const timeline = () => {
    const mobileBreakpoint = 767;
    function copyToClipboard(el,copiedNotice) {
        /* Get the text field */
        const copyText = document.getElementById(el);

        /* Select the text field */
        copyText.select();
        //console.log(copyText.value);
        /* Copy the text inside the text field */
        document.execCommand('copy');

        /* Alert the copied text */
        copiedNotice.addClass('active').html(`Copied <em>${copyText.value}</em>`);
        setTimeout(function() {
            copiedNotice.removeClass('active');
        }, 2000);
        // alert("Copied the text: " + copyText.value);
    }

    const setTimelineYearIndicator = function() {
        const timelineCurYear = $('#timeline__modal .timeline__year').html();
    };

    function openSlide(modalContent,modalImg,openModal) {
        $('html').addClass('modal--opening');
        $('.timeline-modal-content').removeClass('in');
        setTimeout(function() {
            $('#timeline__modal .timeline__owl-carousel > .timeline-modal-content').html(modalContent.html());
            const theId = $('#timeline__modal .timeline-owl__linkshare input').attr('id');
            $('#timeline__modal .timeline-owl__linkshare input').attr('id', `${theId}__tlModal`);
            $('#timeline__modal > div .timeline__img-col .timeline-owl__social').before(modalImg);
            $('.timeline-modal-content').addClass('in');

            if (openModal === 1) {
                //todo - this was adjusted from toggleClass + showclass was added - MM 15/07/21
                $('.timeline__modal').addClass('timeline__modal--open');
                $('.timeline__modal').addClass('show');
                $('html').toggleClass('modal--open');
            }

            $('#timeline__modal .timeline-owl__linkshare').on('click', function() {
                const el = $('input',this).attr('id');
                const copiedNotice = $(this).find('.timeline-owl__linkshare-copied-ok');
                copyToClipboard(el,copiedNotice);
            });

            $('#timeline__modal .timeline-owl__social--link').on('click', function(e) {
                e.preventDefault();
                $(this).next('.timeline-owl__linkshare')
                    .toggleClass('timeline-owl__linkshare--active');
            });

            // set src of modal img if required...
            const imgTag = $('#timeline__modal > div .timeline__img-col img');
            if (imgTag.attr('src') !== '') {
                imgTag.attr('src',imgTag.attr('data-src'));
            }
            // Update hash
            const updatedHash = $('#timeline__modal .timeline-modal-content > div').attr('data-hash');
            history.pushState(null, null, `#${updatedHash}`);
            setTimelineYearIndicator();
        }, 100);
        setTimeout(function() {
            $('html').removeClass('modal--opening');
            $(window).trigger('resize');
        },600);
    }

    function checkLocationHash() {
        if (window.location.hash) {
            const hash = window.location.hash.substring(1); //Puts hash in variable, and removes the # character
            if ($(window).width() > mobileBreakpoint) {
                setTimeout(function() {
                    $('html').addClass('modal--opening');
                    const slideEl = $(`.timeline__grid div[data-hash="${hash}"]`);
                    const modalContent = slideEl.parent();
                    const modalImg = slideEl.parent()
                        .parent()
                        .find('img')
                        .clone();
                    openSlide(modalContent,modalImg,1);
                }, 200);
            } else {
                const target = $(`#timeline_year-${hash}`);
                setTimeout(function() {
                    if (target.length) {
                        //alert(target.offset().top);
                        $('html, body').animate({
                            scrollTop: target.offset().top - $('.banner--timeline').height()
                        }, 1000);
                        return false;
                    }
                },500);
            }
            // hash found
        } else {
            // No hash found
        }
    }

    if ($('body').hasClass('page-template-template-timeline')) {
        let currentDecade = '#decade-0000';
        let prevDecade = currentDecade;
        let decadeTop = '#decade-1913';
        const slideTotal = $('#timeline__modal').attr('data-slide-total');
        const activeFilters = [];

        $(window).on('scroll', function() {
            if ($(window).scrollTop() > 100 && $(window).width() > 767) {
                $('body').addClass('reduced-header--timeline');
            } else {
                $('body').removeClass('reduced-header--timeline');
            }

            // monitor timeline decade anchors.
            $('a[id*="decade-"]').each(function() {
                decadeTop = $(this).offset().top - $(window).scrollTop();
                if (decadeTop < 80) {
                    currentDecade = `#${$(this).attr('id')}`;
                }
            });

            if (prevDecade !== currentDecade) {
                prevDecade = currentDecade;
                $('.timeline_decade.active').removeClass('active');
                $('.timeline__next-prev-title ul>li.active').removeClass('active');
                $(`.banner--timeline [href="${currentDecade}"]`).addClass('active');
                $(`.timeline__next-prev-title a[href="${currentDecade}"]`).parent('li')
                    .addClass('active');
            }
        });

        console.log('build timeline controller');
        let timelineControllerHTML = '<ul class="timeline__nav">';
        let timelineNextPrevHTML = '<div class="timeline__next-prev"><div name="timeline__next-prev"><i class="timeline__prev timeline__arrow-left"></i><i class="timeline__next timeline__arrow-right"></i></div><div class="timeline__next-prev-title"><ul>';
        const timelineCatFilter = $('.timeline__cat-filter');
        let timelineTotalFilters;

        $('.timeline_decade').each(function() {
            timelineControllerHTML += `<li>${$(this)[0].outerHTML}</li>`;
            timelineNextPrevHTML += `<li>${$(this)[0].outerHTML}</li>`;
        });
        timelineControllerHTML += '</ul>';
        timelineNextPrevHTML += '</ul></div>';

        timelineControllerHTML = timelineControllerHTML.replace(/id="/gi, 'href="#');
        timelineControllerHTML = timelineControllerHTML.replace(/sr-only/g, 'timeline-controller__decade');

        timelineNextPrevHTML = timelineNextPrevHTML.replace(/id="/gi, 'href="#');
        timelineNextPrevHTML = timelineNextPrevHTML.replace(/name="/gi, 'id="');
        timelineNextPrevHTML = timelineNextPrevHTML.replace(/sr-only/g, 'timeline-controller__decade');

        $('header.banner .timeline__controller').append(timelineControllerHTML);
        timelineCatFilter.appendTo($('header.banner .timeline__controller')).removeClass('hidden');//.append(timelineCatFilter);
        $('header.banner .timeline__controller').append(timelineNextPrevHTML);
        $('.timeline__next-prev-title ul>li').eq(0)
            .addClass('active');

        $('.timeline__cat-filter>li').on('click',function() {
            const multipleFilters = 0;
            if (multipleFilters === 0) {
                $('.timeline__cat-filter>li').not(this)
                    .removeClass('timeline__cat-filter--active');
                $(this).toggleClass('timeline__cat-filter--active');
            } else {
                $(this).toggleClass('timeline__cat-filter--active');
            }
            const activeFilters = [];

            // Check and apply/remove filters from timeline grid.
            timelineTotalFilters = 0;
            $('.timeline__cat-filter>li').each(function() {
                timelineTotalFilters++;
                if ($(this).hasClass('timeline__cat-filter--active')) {
                    activeFilters.push($(this).text());
                }
            });

            if (activeFilters.length > 0 && activeFilters.length < timelineTotalFilters) {
                $('.timeline__grid').attr('class','timeline__grid');
                $('.timeline__grid').addClass('timeline__grid--filtered animating');
                setTimeout(
                    function() {
                        $('.timeline__grid').removeClass('animating');
                    }, 300
                );

                const arrayLength = activeFilters.length;
                for (let i = 0; i < arrayLength; i++) {
                    $('.timeline__grid').addClass(`timeline__grid-filter--${activeFilters[i]}`);
                }
            } else {
                $('.timeline__grid').attr('class','timeline__grid');
            }
        });
        // Allow grid item cat labels to work as filters.
        $('.timeline__grid .timeline__category').on('click', function() {
            const catToFilter = $(this).text()
                .trim();
            $(`.timeline__cat-filter .timeline__category--${catToFilter}`).trigger('click');
        });

        window.onhashchange = checkLocationHash;
        checkLocationHash();
        setTimelineYearIndicator();

        // Trigger modal and go to slide.
        $('.timeline__grid-item>.timeline__link').on('click', function() {
            console.log('grid item clicked');
            if ($(window).width() > mobileBreakpoint) {
                //e.preventDefault();
                const slide = $(this).data('slide');
                const modalContent = $(this).parent()
                    .find('.modal-content');
                const modalImg = $(this).find('img')
                    .clone();
                openSlide(modalContent, modalImg,1);
            }
        });

        $('.timeline__modal-close').on('click',function() {
            if ($(window).width() > mobileBreakpoint) {
                $('.timeline__modal--open').addClass('fade')
                    .removeClass('timeline__modal--open in');
                $('html').removeClass('modal--open');
                history.pushState('', document.title, window.location.pathname + window.location.search);
            }
        });

        $('.owl-nav .owl-prev').on('click', function(e) {
            e.preventDefault();
            // get slide.
            let curSlide = $(this).parent()
                .parent()
                .find('.timeline-modal-content>div')
                .attr('data-slide');
            curSlide --;
            // if a filter is on, check to find next visible slide.
            if ($('.timeline__grid').hasClass('timeline__grid--filtered')) {
                let isVisible = $(`.timeline__grid .timeline__link[data-slide="${curSlide}"]`).parent()
                    .css('opacity');
                do {
                    if (isVisible < 1) {
                        curSlide --;
                    }
                    if (curSlide < 0) {
                        curSlide = slideTotal;
                    }
                    console.log(curSlide);
                    isVisible = $(`.timeline__grid .timeline__link[data-slide="${curSlide}"]`).parent()
                        .css('opacity');
                    console.log(isVisible);
                }
                while (isVisible < 1);
            }
            if (curSlide < 0) {
                curSlide = slideTotal;
            }
            $('.timeline-modal-content').removeClass('in');
            //change slide.
            const newSlide = $(`.timeline__grid .timeline__link[data-slide="${curSlide}"]`);
            const modalContent = newSlide.parent()
                .find('.modal-content');
            // console.log(modalContent.html());
            const modalImg = newSlide.find('img')
                .clone();

            openSlide(modalContent,modalImg,0);
        });

        $('.owl-nav .owl-next').on('click', function(e) {
            e.preventDefault();
            // get slide.
            let curSlide = $(this).parent()
                .parent()
                .find('.timeline-modal-content>div')
                .attr('data-slide');
            curSlide ++;
            // if a filter is on, check to find next visible slide.
            if ($('.timeline__grid').hasClass('timeline__grid--filtered')) {
                let isVisible = $(`.timeline__grid .timeline__link[data-slide="${curSlide}"]`).parent()
                    .css('opacity');
                do {
                    if (isVisible < 1) {
                        curSlide ++;
                    }
                    if (curSlide > slideTotal) {
                        curSlide = 0;
                    }
                    console.log(curSlide);
                    isVisible = $(`.timeline__grid .timeline__link[data-slide="${curSlide}"]`).parent()
                        .css('opacity');
                    console.log(isVisible);
                }
                while (isVisible < 1);
            }
            if (curSlide > slideTotal) {
                curSlide = 0;
            }
            $('.timeline-modal-content').removeClass('in');
            //change slide.
            const newSlide = $(`.timeline__grid .timeline__link[data-slide="${curSlide}"]`);
            const modalContent = newSlide.parent()
                .find('.modal-content');
            const modalImg = newSlide.find('img')
                .clone();
            openSlide(modalContent,modalImg,0);
        });
        // Timeline navs
        $('.timeline_decade').on('click', function() {
            const elIndex = $(this).parent()
                .index();
        });
        $('.timeline__prev').on('click', function() {
            const activeLi = $('.timeline__next-prev-title ul>li.active');
            if (activeLi.prev('li').length > 0) {
                activeLi.removeClass('active').prev('li')
                    .addClass('active');
                $('.timeline__next-prev-title ul>li.active a').trigger('click');
            }
        });
        $('.timeline__next').on('click', function() {
            const activeLi = $('.timeline__next-prev-title ul>li.active');
            if (activeLi.next('li').length > 0) {
                activeLi.removeClass('active').next('li')
                    .addClass('active');
                $('.timeline__next-prev-title ul>li.active a').trigger('click');
            }
        });
    }
};
export default timeline;
