<?php
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage(get_the_id());
$newsCategories = get_the_terms(get_the_id(), 'category');
$newsThumbnailID = get_post_thumbnail_id();

$authors = get_field('authors');
$content = get_the_content();
$isbn = get_field('isbn');
$date = strtotime(get_the_date());
$year = date('Y', $date);
$file = get_field('publication');

$args = [
    'post_type' => 'publication',
    'numberposts' => 3,
    'post_status' => 'publish',
    'exclude' => [get_the_id()],
    'orderby' => 'date',
    'order' => 'DESC',
];
$recentPublications = get_posts($args);
?>

<div class="custom-publication-single">
    <?php get_template_part('templates/sections/title-bar', null, [
        'title' => get_the_title(),
        'description' => ''
    ]); ?>

    <main class="single-output">
        <div class="contain">

            <div class="row">
                <div class="col-xl-8">
                    <div class="primary-wrapper">
                        <div class="image-wrapper">
                            <?php if(get_the_post_thumbnail_url()) { ?>
                                <img src="<?php the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                            <?php } ?>
                            <div class="download u-case fw-700"><a href="<?= $file['url']; ?>" target="_blank">Download</a></div>
                        </div>
                        <div class="content-wrapper">
                            <?php if($authors) { ?>
                                <div class="authors">
                                    <span class="fw-700">Author:</span>
                                    <ul>
                                        <?php foreach($authors as $author) { ?>
                                            <li><?= $author['author_name']; ?></li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            <?php } ?>
                            <div class="year"><span class="fw-700">Year: </span><?= $year; ?></div>
                            <?php if($isbn) { ?><div class="isbn"><span class="fw-700">ISBN: </span><?= $isbn; ?></div><?php } ?>
                            <hr/>
                            <div class="content"><?= $content; ?></div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4">
                    <?php if($recentPublications) { ?>
                        <div class="recent-publications">
                            <h2>Recent Publications</h2>
                            <div class="row row-eq-height">
                                <?php foreach($recentPublications as $publication) { ?>
                                    <div class="related-col col-lg-6 col-xl-12">
                                        <div class="related-item">
                                            <h3><?= $publication->post_title; ?></h3>
                                            <div class="description"><?= get_the_excerpt($publication->ID); ?></div>
                                            <div class="cta"><a href="<?= get_the_permalink($publication->ID); ?>">Read More</a></div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>

                        </div>
                    <?php } ?>
                </div>
            </div>


        </div>
    </main>
</div>
