<?php
$uncategorisedCategory = get_term_by('slug', 'uncategorised', 'category');
$publicationCategories = get_terms(['taxonomy'=> 'type', 'hide_empty' => false, 'exclude' => $uncategorisedCategory->term_id]);
$queryObject = get_queried_object();
$years = \Blue2\Scruffy\Site::getPostsYears('publication');
?>
<div class="custom-post-archive">
    <?php get_template_part('templates/sections/title-bar', null, [
        'title' => $queryObject->name,
        'description' => get_field('publication_archive_description', 'option')
    ]); ?>
    <div class="contain">
        <?php get_template_part('templates/sections/publication-filter'); ?>
    </div>
    <main class="archive-output">
        <div class="publication-output">
            <?php
            $publications = \Blue2\Scruffy\Controllers\PublicationController::getPublications($queryObject->slug); ?>
            <div class="related-block publication-block">
                <div class="contain">
                    <div class="related-view active">
                        <div class="grid-view">
                            <?php foreach($publications as $publication) {
                                $image = \Blue2\Scruffy\Site::acfImage(get_post_thumbnail_id($publication->ID), 'publication-image'); ?>
                                <div class="grid-item">
                                    <div class="publication-item">
                                        <a href="<?= get_the_permalink($publication->ID); ?>">
                                            <div class="image-wrapper <?= $image['class']; ?>">
                                                <div class="read-more fw-700 u-case"><span>Read More</span></div>
                                                <?= $image['output']; ?>
                                            </div>
                                            <h3 class="fw-700"><?= $publication->post_title; ?></h3>
                                        </a>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                    <hr/>
                </div>
            </div>
        </div>
    </main>
</div>

