<?php
$uncategorisedCategory = get_term_by('slug', 'uncategorised', 'category');
$publicationCategories = get_terms(['taxonomy'=> 'type', 'hide_empty' => false, 'exclude' => $uncategorisedCategory->term_id]);
$queryObject = get_queried_object();
$years = \Blue2\Scruffy\Site::getPostsYears('publication');
$themes = get_terms(['taxonomy'=> 'theme', 'hide_empty' => false]);
?>
<div class="filter-output">
    <h2>Filter results:</h2>
    <div class="filter-holder">
        <ul class="filter-categories">
            <li class="<?= is_post_type_archive('publication') ? 'active-filter' : ""; ?> fw-700"><a href="<?= get_post_type_archive_link('publication'); ?>">All</a></li>
            <?php if($publicationCategories) {
                foreach($publicationCategories as $category) { ?>
                    <li class="<?= is_tax() && $queryObject->slug == $category->slug ? 'active-filter' : ""; ?> fw-700"><a href="<?= get_category_link($category->term_id); ?>"><?= $category->name; ?></a></li>
                <?php } ?>
            <?php } ?>
        </ul>
        <form class="sort-form">
            <div class="form-item select-holder">
                <label for="year" class="sr-only">Year</label>
                <select id="year" name="year" class="fw-700">
                    <option value="">Search by year</option>
                    <?php foreach($years as $year) {
                        $selectedYear = isset($_GET['year']) && $_GET['year'] == $year['YEAR(post_date)'] ? 'selected' : ""; ?>
                        <option value="<?= $year['YEAR(post_date)'] ?>" <?= $selectedYear ?>><?= $year['YEAR(post_date)'];  ?></option>
                    <?php } ?>
                </select>
                <div class="custom-select-arrow"><span class="fas fa-chevron-down"></span></div>
            </div>
            <div class="form-item">
                <label for="keyword" class="sr-only">Keyword</label>
                <input id="keyword" type="text" name="keyword" placeholder="Search by keyword" value="<?= isset($_GET['keyword']) && $_GET['keyword'] ? $_GET['keyword'] : "";  ?>">
            </div>
            <input type="submit" class="u-case fw-700" value="Search">
        </form>
    </div>
</div>
