<?php
$defaultImage = \Blue2\Scruffy\Site::getDefaultImage(get_the_id());
$newsCategories = get_the_terms(get_the_id(), 'category');
$newsThumbnailID = get_post_thumbnail_id();
$newsDate = strtotime(get_the_date());
$newsDate = date('F j, Y', $newsDate);
$authors = get_field('authors');
$authorDescription = get_field('author_description');

$relatedPostArgs = [
    'post_type' => 'post',
    'numberposts' => 10,
    'exclude' => [get_the_id()]
];

$relatedPosts = get_posts($relatedPostArgs);
?>

<div class="custom-news-single">
    <div class="post-header">
        <div class="contain post-header__contain">
            <div class="primary-wrapper">
                <div class="news-info-holder">
                    <?php if($newsCategories) { ?>
                        <ul>
                            <?php foreach($newsCategories as $news) { ?>
                                <li><a href="<?= get_category_link($news->term_id); ?>"><?= $news->name; ?></a></li>
                            <?php } ?>
                        </ul>
                    <?php } ?>
                    <div class="date"><?= $newsDate; ?></div>
                </div>
                <h1><?= the_title(); ?></h1>
            </div>
            <div class="secondary-wrapper">
                <div class="author-info">
                    <div class="author-images">
                        <?php if($authors) {
                            foreach($authors as $author) {
                                $image = \Blue2\Scruffy\Site::acfImage($author['author_image']['id'], 'author-image'); ?>
                                <div class="author-item <?= $image['class']; ?>">
                                    <?= $image['output']; ?>
                                </div>
                            <?php }
                        } else { ?>
                            <div class="author-item default-image">
                                <?= $defaultImage; ?>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="author-description">
                        <?php if($authorDescription) {
                            echo $authorDescription;
                        } else {
                            echo 'by Carnegie UK Trust';
                        } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <main class="post-output">
        <div class="contain">
            <div class="row">
                <div class="offset-lg-2 col-lg-8">
                    <?php if($newsThumbnailID) {
                        $imageAlt = get_post_meta($newsThumbnailID, '_wp_attachment_image_alt', TRUE);
                        $imageDetails = wp_get_attachment_image_src($newsThumbnailID, 'news-single');
                        $image = '<img src="' . $imageDetails[0] . '" alt="' . $imageAlt . '" loading="lazy"/>';
                        $imageClass = 'featured-image';
                        ?>
                        <div class="image-wrapper">
                            <?= $image; ?>
                        </div>
                    <?php } ?>
                    <div class="content-wrapper">
                        <?php the_content(); ?>
                    </div>
                </div>
            </div>
        </div>
    </main>
    <?php if($relatedPosts) { ?>
        <aside class="more-articles">
            <div class="contain">

                <div class="top-wrapper">
                    <h2>Read more</h2>
                    <div class="navigation">
                        <div class="custom-button-prev">
                            <span class="fa-stack">
                              <span class="fas fa-circle fa-stack-2x"></span>
                              <span class="fas fa-chevron-left fa-stack-1x custom-chevron"></span>
                            </span>
                        </div>
                        <div class="custom-button-next">
                            <span class="fa-stack">
                              <span class="fas fa-circle fa-stack-2x"></span>
                              <span class="fas fa-chevron-right fa-stack-1x custom-chevron"></span>
                            </span>
                        </div>

                    </div>
                </div>


                <div class="swiper-container related-post-swiper">
                    <div class="swiper-wrapper">
                        <?php foreach($relatedPosts as $slide) { ?>
                            <div class="swiper-slide">
                                <?php get_template_part('templates/post/content', null, [
                                    'id' => $slide->ID,
                                ]); ?>
                            </div>
                        <?php } wp_reset_postdata(); ?>
                    </div>
                </div>
            </div>
        </aside>
    <?php } ?>
</div>
